#version 330 core

uniform mat4 ModelViewMatrix;
uniform mat4 ModelViewProjectionMatrix;
uniform float time;

in vec4 gs_coords[1];
in vec3 gs_params[1];

out vec2 uv;
out float alpha;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT_VERTEX(VTX, UV) \
	uv = UV; \
	alpha = al; \
	gl_Position = ModelViewProjectionMatrix * vec4(VTX, 1.0); \
	EmitVertex()

void main()
{
	float radius = gs_params[0].x;

	if ( radius > 0.0 )
	{
		vec3 XAxis = vec3(ModelViewMatrix[0][0], ModelViewMatrix[1][0], ModelViewMatrix[2][0]);
		//vec3 YAxis = vec3(ModelViewMatrix[0][1], ModelViewMatrix[1][1], ModelViewMatrix[2][1]);
		//const vec3 XAxis = vec3(1.0, 0.0, 0.0);
		const vec3 YAxis = vec3(0.0, 1.0, 0.0);

		vec4 pos = gl_in[0].gl_Position;
		vec3 eye_pos = vec3(ModelViewMatrix * pos);
		float dist = dot(vec3(0.0, 0.0, -1.0), eye_pos ) - 1.0;
		float al = smoothstep(0.0, 1.0, dist)*gs_params[0].y;

		vec3 a = pos.xyz + (XAxis + YAxis)*radius;
		vec3 b = pos.xyz + (YAxis - XAxis)*radius;
		vec3 c = pos.xyz + (-XAxis - YAxis)*radius;
		vec3 d = pos.xyz + (XAxis - YAxis)*radius;

		EMIT_VERTEX(a, gs_coords[0].zy);
		EMIT_VERTEX(b, gs_coords[0].xy);
		EMIT_VERTEX(d, gs_coords[0].zw);
		EMIT_VERTEX(c, gs_coords[0].xw);

		EndPrimitive();
	}
}
