#version 330 core

uniform mat4 ModelViewMatrix;
uniform float time;

in vec3 POSITION;
in vec3 NORMAL;
in vec3 TANGENT;

out vec3 gs_axis;
out vec3 gs_params; // radius, energy, 1/mass

void main()
{
	vec3 pos = POSITION;
	pos.x += sin(time + pos.z*1.57)*0.1;
	pos.z += cos(time + pos.x*1.57)*0.1;

	gs_axis = NORMAL;
	gs_params = TANGENT;

	const float bulgeRadius = 1.0/5.0;

	float offset = pos.y + time + 2.0;
	float bulge = mod(offset, 8.0)*0.125;
	float len = abs(1.0 - bulge);
	if ( len < bulgeRadius )
	{
		float att = (len/bulgeRadius);
		gs_params.x *= 1.0 - sin(att*3.14)*0.75;
		gs_params.y += sin(att*3.14);
	}

	gl_Position = vec4(pos, 1.0);
}
