#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform mat3 ViewNormalMatrix;

uniform float fade;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec4 extinction;
out vec3 inscatter;
out vec3 eyeDir;
out vec3 lightDir;
out vec3 normal;
out vec2 uv;
out float alpha;

#include <atmosphere_model_include.vert>

void main()
{
	vec3 eye_pos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	float dist = dot(vec3(0.0, 0.0, -1.0), eye_pos) - 1.0;
	alpha = smoothstep(0.0, 1.0, dist*0.1) * fade;

	eyeDir = -eye_pos;
	lightDir = ViewNormalMatrix * SunDirection;

	calculateGroundAtmosphereDualSided(POSITION, NORMAL, extinction, inscatter);

	normal = NormalMatrix * NORMAL;
	uv = TEXCOORD;
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
