#version 330 core

uniform sampler2D depth_buffer;

uniform vec2 CameraRange;
uniform vec2 ScreenSize;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

float read_depth( in vec2 coord )
{
	return (2.0 * CameraRange.x) / (CameraRange.y + CameraRange.x - texture(depth_buffer, coord).x*(CameraRange.y - CameraRange.x) );
}


void main(void)
{
	float depth = read_depth(uv);
	float d;

	float pw = 1.0 / ScreenSize.x;
	float ph = 1.0 / ScreenSize.y;

	// basic SSAO
	float aoCap = 1.0;
	float ao = 0.0;
	float aoMultiplier = 1000.0;
	float depthTolerance = 0.0001;

	for (int i=0; i < 2; i++)
	{
		d = read_depth( vec2(uv.x + pw, uv.y + ph ) );
		ao += min( aoCap, max( 0.0, depth - d - depthTolerance ) * aoMultiplier );

		d = read_depth( vec2(uv.x - pw, uv.y + ph ) );
		ao += min( aoCap, max( 0.0, depth - d - depthTolerance ) * aoMultiplier );

		d = read_depth( vec2( uv.x + pw, uv.y - ph ) );
		ao += min( aoCap, max( 0.0, depth - d - depthTolerance ) * aoMultiplier );

		d = read_depth( vec2( uv.x - pw, uv.y - ph ) );
		ao += min( aoCap, max( 0.0, depth - d - depthTolerance ) * aoMultiplier );

		pw *= 2.0;
		ph *= 2.0;
		aoMultiplier /= 2.0;

		d = read_depth( vec2(uv.x + pw, uv.y ) );
		ao += min( aoCap, max( 0.0, depth - d - depthTolerance ) * aoMultiplier );

		d = read_depth( vec2(uv.x - pw, uv.y ) );
		ao += min( aoCap, max( 0.0, depth - d - depthTolerance ) * aoMultiplier );

		d = read_depth( vec2( uv.x, uv.y - ph ) );
		ao += min( aoCap, max( 0.0, depth - d - depthTolerance ) * aoMultiplier );

		d = read_depth( vec2( uv.x, uv.y - ph ) );
		ao += min( aoCap, max( 0.0, depth - d - depthTolerance ) * aoMultiplier );

		pw *= 2.0;
		ph *= 2.0;
		aoMultiplier /= 2.0;
	}

	ao /= 16.0;
	frag_color = vec4(1.0 - ao);
}
