#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform float explode;

in vec3 gs_normal[3];
in vec2 gs_uv[3];

out vec3 normal;
out vec3 lightDir;
out vec2 uv;

layout(triangles) in;
layout(triangle_strip, max_vertices=3) out;

#include <atmosphere_model_include.vert>

#include <matrix_include.vert>


void main()
{
	vec3 center = (gl_in[0].gl_Position.xyz + gl_in[1].gl_Position.xyz + gl_in[2].gl_Position.xyz) / 3.0;
	vec3 ext_normal = normalize((gs_normal[0] + gs_normal[1] + gs_normal[2]) / 3.0);

	mat3 mr;
	rotate_around_axis(ext_normal, explode*1.5, mr);

	for (int i=0; i < 3; i++)
	{
		vec4 pos = vec4(mr*(gl_in[i].gl_Position.xyz - center) + center + ext_normal*explode, 1.0);
		vec3 sp = vec3(ModelViewMatrix * vec4(SunPosition, 1.0));
		vec3 p = vec3(ModelViewMatrix * pos);
		lightDir = sp - p;
		normal = NormalMatrix * gs_normal[i];
		uv = gs_uv[i];
		gl_Position = ModelViewProjectionMatrix * pos;
		EmitVertex();
	}
	EndPrimitive();
}
