#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec3 normal;
out vec3 lightDir;
out vec2 uv;

#include <atmosphere_model_include.vert>

void main()
{
	vec3 sp = vec3(ModelViewMatrix * vec4(SunPosition, 1.0));
	vec3 p = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	lightDir = sp - p;
	normal = NormalMatrix * NORMAL;
	uv = TEXCOORD;
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION*1.05, 1.0);
}
