#version 330 core

uniform sampler2D clouds;

in vec3 normal;
in vec3 lightDir;
in vec2 uv;

layout (location = 0) out vec4 frag_color;

void main()
{
	const vec4 blue = vec4(2.27*29.0/255.0, 2.27*85.0/255.0, 2.27*112.0/255.0, 1.0);

	vec3 ld = normalize(lightDir);
	vec3 n = normalize(normal);
	float NdotL = max(dot(ld, n), 0.2);
	float NdotE = max(dot(vec3(0.0, 0.0, -1.0), -n), 0.0);

	vec4 cl = texture(clouds, uv).rrrr*pow(NdotE, 4.0)*0.5;
	frag_color = blue* ((1.0 - NdotE)*NdotL) + vec4(pow(NdotL*1.2 - 0.2, 8.0)*0.5) + cl;
}
