#version 330 core

uniform sampler2D diffuse;
uniform sampler2D bumpmap;
uniform sampler2D detail;

in vec2 uv;
in vec2 uv2;
in vec4 extinction;
in vec3 inscatter;
in vec3 eyeDir;
in vec3 lightDir;
in vec3 normal;

layout (location = 0) out vec4 frag_color;

#include <atmosphere_model_include.vert>

#include <shading_models/oren_nayar_model_include.frag>


void main()
{
	vec3 ld = normalize(lightDir);
	vec3 ed = normalize(eyeDir);
	vec3 n = normalize(texture(bumpmap, uv).xyz*2.0 - vec3(1.0));

	vec3 terms = calculate_oren_nayar_model(n, ld, ed, 1.0, 8.0);

	vec4 diff = texture(diffuse, uv) * texture(detail, uv2).r;
	vec4 color = diff*terms.x + diff*terms.y + diff*0.1;

	lightGroundAtmosphere(color, extinction, inscatter);

	frag_color = color;
}
