#version 330 core

uniform mat4 ModelViewMatrix;
uniform mat4 ModelViewProjectionMatrix;

uniform float flash_scale;

in vec3 gs_params[1]; // radius, energy, 1/mass

out vec2 uv;
out vec2 alpha_energy;

layout(points) in;
layout(triangle_strip, max_vertices = 3) out;

#define EMIT_VERTEX(VTX, UV) \
	uv = (UV); \
	alpha_energy = ae; \
	gl_Position = ModelViewProjectionMatrix * vec4((VTX), 1.0); \
	EmitVertex()

void main()
{
	vec3 XAxis = vec3(ModelViewMatrix[0][0], ModelViewMatrix[1][0], ModelViewMatrix[2][0]);

	float radius = gs_params[0].x*2.f;

	if ( flash_scale > 0.0 && radius > 0.0 )
	{
		vec4 pos = gl_in[0].gl_Position;

		vec3 eye_pos = vec3(ModelViewMatrix * pos);
		float dist = dot(vec3(0.0, 0.0, -1.0), eye_pos ) - 1.0;
		vec2 ae = vec2(smoothstep(0.0, 1.0, dist), gs_params[0].y);

		vec3 a = pos.xyz + XAxis*radius;
		vec3 b = pos.xyz - XAxis*radius;
		vec3 c = pos.xyz + normalize(pos.xyz)*flash_scale;

		EMIT_VERTEX(a, vec2(1.0, 0.5));
		EMIT_VERTEX(b, vec2(0.0, 0.5));
		EMIT_VERTEX(c, vec2(0.5, 0.0));

		EndPrimitive();
	}
}
