#version 330 core

uniform sampler2D diffuse_specular;
uniform sampler2D normal_depth;
uniform vec2 viewport;

in vec3 light_dir;
in vec3 color;

layout (location = 0) out vec4 frag_color;

#include <gbuffer_include.frag>

#include <shading_model/blinn_phong_model_include.frag>

void main()
{
	vec2 uv = gl_FragCoord.xy * viewport;
	vec4 ds = texture(diffuse_specular, uv);
	vec4 nd = texture(normal_depth, uv);
	vec3 pos = calc_position(uv, nd.w);

	vec3 n = normalize(nd.xyz);
	vec3 ed = normalize(-pos);
	
	vec3 terms = calculate_blinn_phong_model(n, ld, ed, 8.0);

	frag_color.rgb = color*ds.rgb*terms.x + color*ds.a*terms.y;
	frag_color.a = terms.x;
}
