#version 330 core

uniform sampler2D alphamap;
uniform sampler2D diffuse;
uniform float emissive;
uniform float damage;
uniform float damage_scale;

in vec2 uv;
in vec4 extinction;
in vec3 inscatter;
in vec3 eyeDir;
in vec3 lightDir;
in vec3 normal;

layout (location = 0) out vec4 frag_color;

#include <atmosphere_model_include.vert>

#include <shading_models/oren_nayar_model_include.frag>


void main()
{
	float alpha = texture(alphamap, uv*damage_scale).r;
	if ( alpha < damage ) discard;

	alpha = 1.0 - smoothstep(0.0, 0.1, alpha-damage);

	vec3 ld = normalize(lightDir);
	vec3 ed = normalize(eyeDir);
	vec3 n = normalize(normal);

	vec3 terms = calculate_oren_nayar_model(n, ld, ed, 1.0, 8.0);

	vec4 diff = texture(diffuse, uv);
	vec4 color = diff*terms.x + diff*terms.y + diff*0.1;

	lightGroundAtmosphere(color, extinction, inscatter);

	frag_color = mix(color, vec4(1.0), alpha) + diff*emissive + vec4(emissive*0.25);
}
