#version 330 core

uniform mat4 ModelViewMatrix;
uniform mat4 ModelViewProjectionMatrix;

in vec3 gs_params[]; // radius, energy, 1/mass

out vec3 eyeDir;
out vec2 uv;
out float alpha_fade;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT_VERTEX(VTX, UV) \
	eyeDir = -eye_pos; \
	uv = UV; \
	alpha_fade = alpha; \
	gl_Position = ModelViewProjectionMatrix * vec4(VTX, 1.0); \
	EmitVertex()

void main()
{
	if ( gs_params[0].x > 0.0 )
	{
		vec3 XAxis = vec3(ModelViewMatrix[0][0], ModelViewMatrix[1][0], ModelViewMatrix[2][0]);
		vec3 YAxis = vec3(ModelViewMatrix[0][1], ModelViewMatrix[1][1], ModelViewMatrix[2][1]);

		vec3 pos = gl_in[0].gl_Position.xyz;

		vec3 eye_pos = vec3(ModelViewMatrix * vec4(pos, 1.0));
		float dist = dot(vec3(0.0, 0.0, -1.0), eye_pos ) - 1.0;
		float alpha = smoothstep(0.0, 1.0, dist) * gs_params[0].y;

		float radius = gs_params[0].x;

		vec3 a = pos + (XAxis + YAxis)*radius;
		vec3 b = pos + (YAxis - XAxis)*radius;
		vec3 c = pos + (-XAxis - YAxis)*radius;
		vec3 d = pos + (XAxis - YAxis)*radius;

		EMIT_VERTEX(a, vec2(1.0, 0.0));
		EMIT_VERTEX(b, vec2(0.0, 0.0));
		EMIT_VERTEX(d, vec2(1.0, 1.0));
		EMIT_VERTEX(c, vec2(0.0, 1.0));

		EndPrimitive();
	}
}
