#version 330 core

uniform sampler2D diffuse;
uniform sampler2DShadow depth;

in vec2 uv;
in vec4 shadow_coord;

layout (location = 0) out vec4 frag_color;

#include <forward/shadows_include.frag>

void main()
{
	float s = soft_shadow(depth, shadow_coord, 16.0/1024.0)*0.5 + 0.5;
	frag_color = texture(diffuse, uv) * s;
}
