#version 330 core

uniform mat4 ModelViewMatrix;
uniform mat4 ModelViewProjectionMatrix;

in vec3 gs_params[1]; // radius, energy, 1/mass
in  vec3 gs_velocity[1];

out vec2 uv;
out vec2 alpha_energy;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT_VERTEX(VTX, UV) \
	uv = (UV); \
	alpha_energy = ae; \
	gl_Position = ModelViewProjectionMatrix * vec4((VTX), 1.0); \
	EmitVertex()

void main()
{
	float radius = gs_params[0].x*1.25;
	if ( radius > 0.0 )
	{
		vec4 pos = gl_in[0].gl_Position;

		vec3 eye_pos = vec3(ModelViewMatrix * pos);
		float dist = dot(vec3(0.0, 0.0, -1.0), eye_pos ) - 1.0;
		vec2 ae = vec2(smoothstep(0.0, 1.0, dist), gs_params[0].y);

		vec3 p0 = gl_in[0].gl_Position.xyz;
		vec3 p1 = gs_velocity[0];
		vec3 t = normalize(p1 - p0);
		vec3 n = normalize(p1 + p0);
		vec3 bn = normalize(cross(t, n));
		n = normalize(cross(bn, t));

		vec3 a = pos.xyz + (n + bn)*radius;
		vec3 b = pos.xyz + (bn - n)*radius;
		vec3 c = pos.xyz + (-n - bn)*radius;
		vec3 d = pos.xyz + (n - bn)*radius;
		
		EMIT_VERTEX(a, vec2(1.0, 0.0));
		EMIT_VERTEX(b, vec2(0.0, 0.0));
		EMIT_VERTEX(d, vec2(1.0, 1.0));
		EMIT_VERTEX(c, vec2(0.0, 1.0));

		EndPrimitive();
	}
}
