#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat4 WorldMatrix;
uniform mat3 WorldNormalMatrix;
uniform mat3 NormalMatrix;
uniform mat3 ViewNormalMatrix;
uniform mat4 TextureMatrix;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec2 uv;
out vec4 extinction;
out vec3 inscatter;
out vec3 eyeDir;
out vec3 lightDir;
out vec3 normal;
out vec4 shadow_coord;

#include <atmosphere_model_include.vert>

void main()
{
	vec3 pos = vec3(WorldMatrix * vec4(POSITION, 1.0));
	vec3 n = normalize(WorldNormalMatrix * NORMAL);

	calculateGroundAtmosphere(pos, n, extinction, inscatter);

	uv = TEXCOORD;

	lightDir = ViewNormalMatrix * SunDirection;
	eyeDir = -vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	normal = NormalMatrix * NORMAL;

	shadow_coord = TextureMatrix * WorldMatrix * vec4(POSITION, 1.0);
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
