#version 330 core

uniform mat4 ModelViewMatrix;
uniform mat4 ModelViewProjectionMatrix;
uniform float scale;
uniform float offset;
uniform float vortex_angle;
uniform float vortex_radius;

in vec3 gs_params[1]; // radius, energy, 1/mass

out vec2 uv;
out vec2 alpha_energy;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define PI_OVER_TWO 1.5707963267948966192313216916398

vec3 vortex_y(in vec3 pos, in vec3 center, in float radius, in float angle)
{
	vec3 p = pos - center;
	float len = length(p);
	float d = cos( (p.y / radius) * PI_OVER_TWO );
	d *= 1.f - (len <= radius ? len/radius : 1.0);
	float c = cos(angle*d);
	float s = sin(angle*d);
	float x = p.x;
	p.x = c*p.x - s*p.z;
	p.z = s*x + c*p.z;
	return p + center;
}


#define EMIT_VERTEX(VTX, UV) \
	uv = (UV); \
	alpha_energy = ae; \
	gl_Position = ModelViewProjectionMatrix * vec4((VTX), 1.0); \
	EmitVertex()

void main()
{
	vec3 XAxis = vec3(ModelViewMatrix[0][0], ModelViewMatrix[1][0], ModelViewMatrix[2][0]);
	vec3 YAxis = vec3(ModelViewMatrix[0][1], ModelViewMatrix[1][1], ModelViewMatrix[2][1]);

	float radius = gs_params[0].x;

	if ( radius > 0.0 )
	{
		vec4 pos = gl_in[0].gl_Position;

		vec3 vpos = pos.xyz;
		vpos.xz *= 1.0 - pow(cos((pos.y)/60.0), 16.0);
		vpos.y += 4.0;

		vpos = mix(pos.xyz, vpos, vortex_radius);
		pos.xyz = vortex_y(vpos, vec3(0.0), 60.0, vortex_angle);

		vec3 eye_pos = vec3(ModelViewMatrix * pos);
		float eye_dist = dot(vec3(0.0, 0.0, -1.0), eye_pos ) - 1.0;
		vec2 ae = vec2(smoothstep(0.0, 1.0, eye_dist), gs_params[0].y);

		float dist = distance(offset, eye_pos.z)*(1.0/10.0);
		float k = smoothstep(0.0, 0.4, dist) - smoothstep(0.6, 1.0, dist);
		pos.xyz += XAxis*k*scale;
		radius += k*scale;

		vec3 a = pos.xyz + (XAxis + YAxis)*radius;
		vec3 b = pos.xyz + (YAxis - XAxis)*radius;
		vec3 c = pos.xyz + (-XAxis - YAxis)*radius;
		vec3 d = pos.xyz + (XAxis - YAxis)*radius;

		EMIT_VERTEX(a, vec2(1.0, 0.0));
		EMIT_VERTEX(b, vec2(0.0, 0.0));
		EMIT_VERTEX(d, vec2(1.0, 1.0));
		EMIT_VERTEX(c, vec2(0.0, 1.0));

		EndPrimitive();
	}
}
