float3 Pos;
float Angle;
float Alpha;
float4x4 View;
float4x4 Proj;
float2 Size;

float4x4 Rotation;

Texture2D Tex;
SamplerState SS;

struct VSInput
{
	float2 TexCoord: TEXCOORD;
};

struct VSOutput
{
	float4 ClipPosition: SV_POSITION;
	float2 TexCoord: TEXCOORD;
};

VSOutput vsMain(VSInput input)
{
	/*float2 p0 = (input.TexCoord - 0.5) * Size;
	float2 p1 = float2(p0.x, 0.0);
	float2 p2 = float2(p1.x * cos(Angle) - p1.y * sin(Angle), p1.y * cos(Angle) + p1.x * sin(Angle));
	
	float4 p = mul(View, float4(Pos + float3(p2, -p0.y), 1.0));*/

	float2 s = (input.TexCoord - 0.5) * Size;

	float4 pw = mul(Rotation, float4(s.x, 0, -s.y, 1.0)) + float4(Pos, 0.0);
	float4 p = mul(View, pw);

	VSOutput output;
	output.ClipPosition = mul(Proj, p);
	output.TexCoord = input.TexCoord;

	return output;
}

float4 psMain(VSOutput input): SV_TARGET
{
	float4 c = Tex.Sample(SS, input.TexCoord) * float4(1, 1, 1, Alpha);
	return float4(c.xyz * c.w, 1.0);
}
