
CubeOutput vsMain(CubeInput Input)
{
	CubeOutput output;
	output.PositionScale = Input.PositionScale;
	output.Rotation = Input.Rotation;

	output.PositionScale.z += sin(Time*0.41+output.PositionScale.y*0.03)*20;
	output.PositionScale.x += cos(Time*0.6077+output.PositionScale.z*0.053)*20;
	output.PositionScale.y += cos(Time*0.3057+output.PositionScale.x*0.053+2)*20;
	
	float3 p = output.PositionScale.xyz;
	float scale = 2+sin(Time*0.4+p.z*0.2) * cos(Time*0.3+p.y*0.17) * sin(Time*0.2+p.z*0.12)*2;
	output.PositionScale.w *= scale*0.5;
	output.PositionScale.w *= 1.5;

	output.Rotation.xyz = normalize(float3(
		sin(Time+output.PositionScale.y*0.1),
		cos(Time*0.23+output.PositionScale.x*0.12+1),
		cos(Time*0.3+output.PositionScale.x*0.02)));
	output.Rotation.w = Time*0.1;

	scale = output.PositionScale.w;
	output.Color.xyz = max(0, float3(0.7-scale*0.25,0.8-scale*0.28,0.76-scale*0.26))+0.1;
	output.Color.w = 1.0;

	return output;
}