
float4 PositionRect;
float4 TexCoordRect;

Texture2D Original, Blur1, Blur2, DepthMap;

SamplerState StdSampler
{
	AddressU = CLAMP;
	AddressV = CLAMP;
	AddressW = CLAMP;
};

float2 Delta;

struct VSInput
{
	float2 Position: POSITION;
};

struct VSOutput
{
	float4 Position: SV_Position;
	float2 TexCoord: TEXCOORD;
};

VSOutput vsMain(VSInput Input)
{
	VSOutput Output;
	Output.Position = float4(Input.Position * PositionRect.zw + PositionRect.xy, 0, 1);
	Output.TexCoord = Input.Position * TexCoordRect.zw;
	Output.TexCoord.y = 1 - Output.TexCoord.y;
	Output.TexCoord += TexCoordRect.xy;
	return Output;
}

float FocusDepth;
float FocusFallOff;

float4 psMain(VSOutput Input): SV_Target
{
	float depth = DepthMap.Sample(StdSampler, Input.TexCoord);
	float4 orig = Original.Sample(StdSampler, Input.TexCoord);
	float4 blur1 = Blur1.Sample(StdSampler, Input.TexCoord);
	float4 blur2 = Blur2.Sample(StdSampler, Input.TexCoord);
	

	float focusDepth = FocusDepth;
	float d = abs(depth-focusDepth) / FocusFallOff;

	float f1 = max(0, 1.0 - d);
	float f2 = max(0, d<1 ? d : 2-d);
	float f3 = min(1, max(0, d-1));

	float4 c = 0;
	c += orig * f1;
	c += blur1 * f2;
	c += blur2 * f3;
	
	return c;
}
