
Texture2D ViewNormalMap;
Texture2D DepthMap;
float4x4 ViewProjectionInverse;
float2 Resolution;

float3 ViewDirBL, ViewDirDX, ViewDirDY, CameraPosition;

float4 psMain(GSOutput Input): SV_Target
{
	float2 clipCoord = (Input.ClipPosition.xy/Input.ClipPosition.w)*0.5+0.5;
	
	float2 tc = clipCoord;
	tc.y = 1-tc.y;
	int3 itc = int3(tc*Resolution,0);
	float3 viewNormal = ViewNormalMap.Load(itc).xyz;

	// Reconstruct world position
	float3 viewDir = normalize( ViewDirBL + ViewDirDX * clipCoord.x + ViewDirDY * clipCoord.y );
	float depth = DepthMap.Load(itc).x;
	float3 worldPosition = CameraPosition + viewDir * depth;
	
	float ao = 0;
	float dist = length(worldPosition-Input.CubeCenterSize.xyz);

	ao = max(1 - dist/(Input.CubeCenterSize.w*AOVMargin), 0);
	//ao = sin(ao*50)*ao;
	ao *= 0.3;
		
	return float4(ao,ao,ao,1);
}


