uniform sampler2D TEX;

uniform float HUE;
uniform float SAT;
uniform float VAL;

vec3 rgbtohsv(vec3 c) {
    vec3 hsv;
    hsv.b = max(max(c.r,c.g),c.b);
    c = normalize(c);
    float cmin = min(min(c.r,c.g),c.b);
    float cmax = max(max(c.r,c.g),c.b);
    hsv.g = cmax - cmin;
    c = vec3((c.r - cmin) / hsv.g,(c.g - cmin) / hsv.g,(c.b - cmin) / hsv.g);
    cmax = max(max(c.r,c.g),c.b);
    if(cmax == c.r) {
        hsv.r = 60.0 * (c.g - c.b);
        if(hsv.r < 0) hsv.r += 360.0;
    } else if(cmax == c.g) {
        hsv.r = 120.0 + 60.0 * (c.b - c.r);
    } else {
        hsv.r = 240.0 + 60.0 * (c.r - c.g);
    }
    return hsv;
}

vec3 hsvtorgb(vec3 c) {
    vec3 rgb;
    rgb.rg = clamp(rgb.rg,0.0,1.0);
    if(rgb.b < 0.0) rgb.b += 360.0;
    if(rgb.b >= 360.0) rgb.b -= 360.0;

    return rgb;
}

void main() {
    gl_FragColor = hsvtorgb(rgbtohsv(texture2D(TEX,gl_TexCoord[0].st).rgb) + vec3(HUE,SAT,VAL));
}