/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11;

import com.sun.opengl.impl.FunctionAvailabilityCache;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.x11.GLX;
import com.sun.opengl.impl.x11.GLXExt;
import com.sun.opengl.impl.x11.GLXExtImpl;
import com.sun.opengl.impl.x11.GLXExtProcAddressTable;
import com.sun.opengl.impl.x11.X11GLDrawable;
import com.sun.opengl.impl.x11.X11GLDrawableFactory;
import com.sun.opengl.impl.x11.XVisualInfo;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;

public abstract class X11GLContext
extends GLContextImpl {
    protected X11GLDrawable drawable;
    protected long context;
    private boolean glXQueryExtensionsStringInitialized;
    private boolean glXQueryExtensionsStringAvailable;
    private static final Map functionNameMap;
    private GLXExt glXExt;
    private GLXExtProcAddressTable glXExtProcAddressTable;
    protected long mostRecentDisplay;
    static final /* synthetic */ boolean $assertionsDisabled;

    public X11GLContext(X11GLDrawable x11GLDrawable, GLContext gLContext) {
        super(gLContext);
        this.drawable = x11GLDrawable;
    }

    public Object getPlatformGLExtensions() {
        return this.getGLXExt();
    }

    public GLXExt getGLXExt() {
        if (this.glXExt == null) {
            this.glXExt = new GLXExtImpl(this);
        }
        return this.glXExt;
    }

    public GLDrawable getGLDrawable() {
        return this.drawable;
    }

    protected String mapToRealGLFunctionName(String string) {
        String string2 = (String)functionNameMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected String mapToRealGLExtensionName(String string) {
        return string;
    }

    protected abstract void create();

    protected void createContext(boolean bl) {
        XVisualInfo xVisualInfo = this.drawable.chooseVisual(bl);
        X11GLContext x11GLContext = (X11GLContext)GLContextShareSet.getShareContext(this);
        long l = 0L;
        if (x11GLContext != null && (l = x11GLContext.getContext()) == 0L) {
            throw new GLException("GLContextShareSet returned an invalid OpenGL context");
        }
        this.context = GLX.glXCreateContext(this.drawable.getDisplay(), xVisualInfo, l, bl);
        if (this.context == 0L) {
            throw new GLException("Unable to create OpenGL context");
        }
        GLContextShareSet.contextCreated(this);
    }

    protected int makeCurrentImpl() throws GLException {
        boolean bl = false;
        if (this.context == 0L) {
            this.create();
            if (DEBUG) {
                System.err.println(X11GLContext.getThreadName() + ": !!! Created GL context for " + this.getClass().getName());
            }
            bl = true;
        }
        if (!GLX.glXMakeCurrent(this.drawable.getDisplay(), this.drawable.getDrawable(), this.context)) {
            throw new GLException("Error making context current");
        }
        this.mostRecentDisplay = this.drawable.getDisplay();
        if (DEBUG && (VERBOSE || bl)) {
            System.err.println(X11GLContext.getThreadName() + ": glXMakeCurrent(display " + X11GLContext.toHexString(this.drawable.getDisplay()) + ", drawable " + X11GLContext.toHexString(this.drawable.getDrawable()) + ", context " + X11GLContext.toHexString(this.context) + ") succeeded");
        }
        if (bl) {
            this.resetGLFunctionAvailability();
            return 2;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseImpl() throws GLException {
        this.lockToolkit();
        try {
            if (!GLX.glXMakeCurrent(this.mostRecentDisplay, 0L, 0L)) {
                throw new GLException("Error freeing OpenGL context");
            }
        }
        finally {
            this.unlockToolkit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyImpl() throws GLException {
        this.lockToolkit();
        try {
            if (this.context != 0L) {
                if (DEBUG) {
                    System.err.println("glXDestroyContext(0x" + Long.toHexString(this.mostRecentDisplay) + ", 0x" + Long.toHexString(this.context) + ")");
                }
                GLX.glXDestroyContext(this.mostRecentDisplay, this.context);
                if (DEBUG) {
                    System.err.println("!!! Destroyed OpenGL context " + this.context);
                }
                this.context = 0L;
                this.mostRecentDisplay = 0L;
                GLContextShareSet.contextDestroyed(this);
            }
        }
        finally {
            this.unlockToolkit();
        }
    }

    public boolean isCreated() {
        return this.context != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(GLContext gLContext, int n) throws GLException {
        long l = this.getContext();
        long l2 = ((X11GLContext)gLContext).getContext();
        if (l2 == 0L) {
            throw new GLException("Source OpenGL context has not been created");
        }
        if (l == 0L) {
            throw new GLException("Destination OpenGL context has not been created");
        }
        if (this.mostRecentDisplay == 0L) {
            throw new GLException("Connection to X display not yet set up");
        }
        this.lockToolkit();
        try {
            GLX.glXCopyContext(this.mostRecentDisplay, l2, l, n);
        }
        finally {
            this.unlockToolkit();
        }
    }

    protected void resetGLFunctionAvailability() {
        super.resetGLFunctionAvailability();
        if (DEBUG) {
            System.err.println(X11GLContext.getThreadName() + ": !!! Initializing GLX extension address table");
        }
        this.resetProcAddressTable(this.getGLXExtProcAddressTable());
    }

    public GLXExtProcAddressTable getGLXExtProcAddressTable() {
        if (this.glXExtProcAddressTable == null) {
            this.glXExtProcAddressTable = new GLXExtProcAddressTable();
        }
        return this.glXExtProcAddressTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getPlatformExtensionsString() {
        if (this.mostRecentDisplay == 0L) {
            throw new GLException("Context not current");
        }
        if (!this.glXQueryExtensionsStringInitialized) {
            this.glXQueryExtensionsStringAvailable = GLDrawableFactoryImpl.getFactoryImpl().dynamicLookupFunction("glXQueryExtensionsString") != 0L;
            this.glXQueryExtensionsStringInitialized = true;
        }
        if (this.glXQueryExtensionsStringAvailable) {
            this.lockToolkit();
            try {
                String string = GLX.glXQueryExtensionsString(this.mostRecentDisplay, GLX.DefaultScreen(this.mostRecentDisplay));
                if (DEBUG) {
                    System.err.println("!!! GLX extensions: " + string);
                }
                String string2 = string;
                return string2;
            }
            finally {
                this.unlockToolkit();
            }
        }
        return "";
    }

    protected boolean isFunctionAvailable(String string) {
        boolean bl = super.isFunctionAvailable(string);
        if (!$assertionsDisabled && bl && this.getGLProcAddressTable().getAddressFor(this.mapToRealGLFunctionName(string)) == 0L && !FunctionAvailabilityCache.isPartOfGLCore("1.1", this.mapToRealGLFunctionName(string))) {
            throw new AssertionError();
        }
        return bl;
    }

    public boolean isExtensionAvailable(String string) {
        if (string.equals("GL_ARB_pbuffer") || string.equals("GL_ARB_pixel_format")) {
            return GLDrawableFactory.getFactory().canCreateGLPbuffer();
        }
        return super.isExtensionAvailable(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSwapInterval(int n) {
        this.lockToolkit();
        try {
            GLXExt gLXExt = this.getGLXExt();
            if (gLXExt.isExtensionAvailable("GLX_SGI_swap_control")) {
                gLXExt.glXSwapIntervalSGI(n);
            }
        }
        finally {
            this.unlockToolkit();
        }
    }

    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        return this.getGLXExt().glXAllocateMemoryNV(n, f, f2, f3);
    }

    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOptimizable() {
        if (!super.isOptimizable()) return false;
        X11GLDrawableFactory.getX11Factory();
        if (X11GLDrawableFactory.isVendorATI()) return false;
        return true;
    }

    public long getContext() {
        return this.context;
    }

    protected void lockToolkit() {
        X11GLDrawableFactory.getX11Factory().lockToolkit();
    }

    protected void unlockToolkit() {
        X11GLDrawableFactory.getX11Factory().unlockToolkit();
    }

    static {
        $assertionsDisabled = !X11GLContext.class.desiredAssertionStatus();
        functionNameMap = new HashMap();
        functionNameMap.put("glAllocateMemoryNV", "glXAllocateMemoryNV");
        functionNameMap.put("glFreeMemoryNV", "glXFreeMemoryNV");
    }
}

