/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.glgraphics;

import codeanticode.glgraphics.GLConstants;
import codeanticode.glgraphics.GLFramebufferObject;
import codeanticode.glgraphics.GLGraphics;
import codeanticode.glgraphics.GLModel;
import codeanticode.glgraphics.GLModelEffect;
import codeanticode.glgraphics.GLState;
import codeanticode.glgraphics.GLTexture;
import codeanticode.glgraphics.GLTextureParameters;
import codeanticode.glgraphics.GLUtils;
import com.sun.opengl.util.BufferUtil;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.opengl.PGraphicsOpenGL;

public class GLGraphicsOffScreen
extends PGraphicsOpenGL
implements GLConstants {
    protected GLFramebufferObject multisampleFBO;
    protected GLFramebufferObject FBO;
    protected int colorBufferMulti = 0;
    protected int depthStencilBuffer = 0;
    protected GLTexture colorTex;
    protected GLState glstate;
    protected GLCapabilities glcaps;
    protected int multisampleLevel = 4;
    protected boolean multisampleEnabled;
    protected GLTextureParameters colorTexParams;
    protected boolean glMode = false;
    protected float[] modelviewTM;
    protected static final int MAX_LIGHTS_GL = 8;
    protected boolean lightsGL = false;
    protected int lightCountGL = 0;
    protected int[] lightTypeGL;
    protected float[][] lightPositionGL;
    protected float[][] lightNormalGL;
    protected float[] lightFalloffConstantGL;
    protected float[] lightFalloffLinearGL;
    protected float[] lightFalloffQuadraticGL;
    protected float[] lightSpotAngleGL;
    protected float[] lightSpotAngleCosGL;
    protected float[] lightSpotConcentrationGL;
    protected float[][] lightDiffuseGL;
    protected float[][] lightSpecularGL;
    protected float[] currentLightSpecularGL;
    protected float currentLightFalloffConstantGL;
    protected float currentLightFalloffLinearGL;
    protected float currentLightFalloffQuadraticGL;
    protected float[] zeroLightGL = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    protected int saveLightCount;
    protected boolean lightsAllocated = false;
    protected GLGraphics mainRenderer;

    public GLGraphicsOffScreen(PApplet pApplet, int n, int n2) {
        this.multisampleEnabled = false;
        this.colorTexParams = new GLTextureParameters();
        this.multisampleLevel = 4;
        this.setParent(pApplet);
        this.setSize(n, n2);
    }

    public GLGraphicsOffScreen(PApplet pApplet, int n, int n2, boolean bl) {
        this.multisampleEnabled = bl;
        this.colorTexParams = new GLTextureParameters();
        this.multisampleLevel = 4;
        this.setParent(pApplet);
        this.setSize(n, n2);
    }

    public GLGraphicsOffScreen(PApplet pApplet, int n, int n2, boolean bl, int n3) {
        this.multisampleEnabled = bl;
        this.colorTexParams = new GLTextureParameters();
        this.multisampleLevel = n3;
        this.setParent(pApplet);
        this.setSize(n, n2);
    }

    public GLGraphicsOffScreen(PApplet pApplet, int n, int n2, GLTextureParameters gLTextureParameters) {
        this.multisampleEnabled = false;
        this.colorTexParams = gLTextureParameters;
        this.multisampleLevel = 4;
        this.setParent(pApplet);
        this.setSize(n, n2);
    }

    public GLGraphicsOffScreen(PApplet pApplet, int n, int n2, GLTextureParameters gLTextureParameters, boolean bl) {
        this.multisampleEnabled = bl;
        this.colorTexParams = gLTextureParameters;
        this.multisampleLevel = 4;
        this.setParent(pApplet);
        this.setSize(n, n2);
    }

    public GLGraphicsOffScreen(PApplet pApplet, int n, int n2, GLTextureParameters gLTextureParameters, boolean bl, int n3) {
        this.multisampleEnabled = bl;
        this.colorTexParams = gLTextureParameters;
        this.multisampleLevel = n3;
        this.setParent(pApplet);
        this.setSize(n, n2);
    }

    public GLTexture getTexture() {
        return this.colorTex;
    }

    public GLCapabilities getCapabilities() {
        return this.glcaps;
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        if (!this.lightsAllocated) {
            this.lightTypeGL = new int[8];
            this.lightPositionGL = new float[8][4];
            this.lightNormalGL = new float[8][4];
            this.lightDiffuseGL = new float[8][4];
            this.lightSpecularGL = new float[8][4];
            this.lightFalloffConstantGL = new float[8];
            this.lightFalloffLinearGL = new float[8];
            this.lightFalloffQuadraticGL = new float[8];
            this.lightSpotAngleGL = new float[8];
            this.lightSpotAngleCosGL = new float[8];
            this.lightSpotConcentrationGL = new float[8];
            this.currentLightSpecularGL = new float[4];
            this.lightsAllocated = true;
        }
    }

    public void delete() {
        this.releaseFramebuffer();
    }

    public GL beginGL() {
        super.beginGL();
        this.glMode = true;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        return this.gl;
    }

    public void endGL() {
        this.glMode = false;
        super.endGL();
    }

    public void beginDraw() {
        boolean bl = this.parent.width != this.width || this.parent.height != this.height;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        this.gl.glMatrixMode(5889);
        this.gl.glPushMatrix();
        if (bl) {
            int n = this.width;
            int n2 = this.height;
            float f4 = 60.0f;
            f3 = (float)n / 2.0f;
            f2 = (float)n2 / 2.0f;
            float f5 = (float)Math.PI * f4 / 360.0f;
            float f6 = (float)Math.tan(f5);
            f = f2 / f6;
            float f7 = f / 10.0f;
            float f8 = f * 10.0f;
            float f9 = (float)n / (float)n2;
            this.gl.glLoadIdentity();
            this.perspective(f4 * ((float)Math.PI / 180), f9, f7, f8);
        }
        super.beginDraw();
        this.gl.glMatrixMode(5888);
        this.gl.glPushMatrix();
        this.gl.glScalef(1.0f, -1.0f, 1.0f);
        if (bl) {
            this.gl.glLoadIdentity();
            this.camera(f3, f2, f, f3, f2, 0.0f, 0.0f, 1.0f, 0.0f);
        }
        if (bl) {
            this.gl.glPushAttrib(2048);
            this.gl.glViewport(0, 0, this.width, this.height);
        }
        if (this.multisampleEnabled) {
            this.glstate.pushFramebuffer();
            this.glstate.setFramebuffer(this.multisampleFBO);
            this.gl.glDrawBuffer(36064);
        } else {
            this.glstate.pushFramebuffer();
            this.glstate.setFramebuffer(this.FBO);
            this.FBO.setDrawBuffer(this.colorTex);
        }
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.gl.glClear(256);
        if (this.mainRenderer != null) {
            this.mainRenderer.setOffScreenRenderer(this);
            this.mainRenderer.saveLights();
            this.mainRenderer.disableLights();
        }
        this.lightsGL = false;
        this.lightCountGL = 0;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
    }

    public void endDraw() {
        boolean bl;
        boolean bl2 = bl = this.parent.width != this.width || this.parent.height != this.height;
        if (this.mainRenderer != null) {
            this.mainRenderer.setOffScreenRenderer(null);
            this.mainRenderer.restoreLights();
        }
        super.endDraw();
        if (this.multisampleEnabled) {
            this.gl.glBindFramebufferEXT(36008, this.multisampleFBO.getFramebufferID());
            this.gl.glBindFramebufferEXT(36009, this.FBO.getFramebufferID());
            this.gl.glBlitFramebufferEXT(0, 0, this.width, this.height, 0, 0, this.width, this.height, 16384, 9728);
            this.glstate.popFramebuffer();
        } else {
            this.glstate.popFramebuffer();
        }
        if (bl) {
            this.gl.glPopAttrib();
        }
        this.gl.glMatrixMode(5889);
        this.gl.glPopMatrix();
        this.gl.glMatrixMode(5888);
        this.gl.glPopMatrix();
    }

    public void setDepthMask(boolean bl) {
        this.gl.glDepthMask(bl);
    }

    public void enableMultisampling() {
        this.gl.glEnable(32925);
    }

    public void disableMultisampling() {
        this.gl.glDisable(32925);
    }

    public void pushMatrix() {
        if (this.glMode) {
            this.gl.glPushMatrix();
        } else {
            super.pushMatrix();
        }
    }

    public void popMatrix() {
        if (this.glMode) {
            this.gl.glPopMatrix();
        } else {
            super.popMatrix();
        }
    }

    public void translate(float f, float f2) {
        if (this.glMode) {
            this.gl.glTranslatef(f, f2, 0.0f);
        } else {
            super.translate(f, f2, 0.0f);
        }
    }

    public void translate(float f, float f2, float f3) {
        if (this.glMode) {
            this.gl.glTranslatef(f, f2, f3);
        } else {
            super.translate(f, f2, f3);
        }
    }

    public void rotate(float f) {
        if (this.glMode) {
            this.gl.glRotatef(PApplet.degrees((float)f), 0.0f, 0.0f, 1.0f);
        } else {
            super.rotate(f);
        }
    }

    public void rotateX(float f) {
        if (this.glMode) {
            this.gl.glRotatef(PApplet.degrees((float)f), 1.0f, 0.0f, 0.0f);
        } else {
            super.rotateX(f);
        }
    }

    public void rotateY(float f) {
        if (this.glMode) {
            this.gl.glRotatef(PApplet.degrees((float)f), 0.0f, 1.0f, 0.0f);
        } else {
            super.rotateY(f);
        }
    }

    public void rotateZ(float f) {
        if (this.glMode) {
            this.gl.glRotatef(PApplet.degrees((float)f), 0.0f, 0.0f, 1.0f);
        } else {
            super.rotateZ(f);
        }
    }

    public void rotate(float f, float f2, float f3, float f4) {
        if (this.glMode) {
            this.gl.glRotatef(PApplet.degrees((float)f), f2, f3, f4);
        } else {
            super.rotate(f, f2, f3, f4);
        }
    }

    public void scale(float f) {
        if (this.glMode) {
            this.gl.glScalef(f, f, f);
        } else {
            super.scale(f);
        }
    }

    public void scale(float f, float f2) {
        if (this.glMode) {
            this.gl.glScalef(f, f2, 1.0f);
        } else {
            super.scale(f, f2);
        }
    }

    public void scale(float f, float f2, float f3) {
        if (this.glMode) {
            this.gl.glScalef(f, f2, f);
        } else {
            super.scale(f, f2, f3);
        }
    }

    public void lights() {
        if (this.glMode) {
            this.glEnableLights();
            int n = this.colorMode;
            this.colorMode = 1;
            this.lightFalloff(1.0f, 0.0f, 0.0f);
            this.lightSpecular(0.0f, 0.0f, 0.0f);
            this.ambientLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f);
            this.directionalLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f, 0.0f, 0.0f, -1.0f);
            this.colorMode = n;
        } else {
            super.lights();
        }
    }

    public void saveLights() {
        this.saveLightCount = this.glMode ? this.lightCountGL : this.lightCount;
    }

    public void restoreLights() {
        if (this.glMode) {
            this.lightCountGL = this.saveLightCount;
            for (int i = 0; i < this.lightCountGL; ++i) {
                this.glLightEnable(i);
                if (this.lightTypeGL[i] == 0) {
                    this.glLightAmbient(i);
                    this.glLightPosition(i);
                    this.glLightFalloff(i);
                    this.glLightNoSpot(i);
                    this.glLightNoDiffuse(i);
                    this.glLightNoSpecular(i);
                    continue;
                }
                if (this.lightTypeGL[i] == 1) {
                    this.glLightNoAmbient(i);
                    this.glLightDirection(i);
                    this.glLightDiffuse(i);
                    this.glLightSpecular(i);
                    this.glLightFalloff(i);
                    this.glLightNoSpot(i);
                    continue;
                }
                if (this.lightTypeGL[i] == 2) {
                    this.glLightNoAmbient(i);
                    this.glLightPosition(i);
                    this.glLightDiffuse(i);
                    this.glLightSpecular(i);
                    this.glLightFalloff(i);
                    this.glLightNoSpot(i);
                    continue;
                }
                if (this.lightTypeGL[i] != 3) continue;
                this.glLightNoAmbient(i);
                this.glLightPosition(i);
                this.glLightDirection(i);
                this.glLightDiffuse(i);
                this.glLightSpecular(i);
                this.glLightFalloff(i);
                this.glLightSpotAngle(i);
                this.glLightSpotConcentration(i);
            }
        } else {
            this.lightCount = this.saveLightCount;
        }
    }

    public void noLights() {
        if (this.glMode) {
            this.glDisableLights();
            this.lightCountGL = 0;
        } else {
            super.noLights();
        }
    }

    public void ambientLight(float f, float f2, float f3) {
        if (this.glMode) {
            this.ambientLight(f, f2, f3, 0.0f, 0.0f, 0.0f);
        } else {
            super.ambientLight(f, f2, f3, 0.0f, 0.0f, 0.0f);
        }
    }

    public void ambientLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (!this.glMode) {
            super.ambientLight(f, f2, f3, f4, f5, f6);
            return;
        }
        if (!this.lightsGL) {
            this.glEnableLights();
        }
        if (this.lightCountGL == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuseGL[this.lightCountGL][0] = this.calcR;
        this.lightDiffuseGL[this.lightCountGL][1] = this.calcG;
        this.lightDiffuseGL[this.lightCountGL][2] = this.calcB;
        this.lightDiffuseGL[this.lightCountGL][3] = 1.0f;
        this.lightTypeGL[this.lightCountGL] = 0;
        this.lightFalloffConstantGL[this.lightCountGL] = this.currentLightFalloffConstantGL;
        this.lightFalloffLinearGL[this.lightCountGL] = this.currentLightFalloffLinearGL;
        this.lightFalloffQuadraticGL[this.lightCountGL] = this.currentLightFalloffQuadraticGL;
        this.lightPositionGL[this.lightCountGL][0] = f4;
        this.lightPositionGL[this.lightCountGL][1] = f5;
        this.lightPositionGL[this.lightCountGL][2] = f6;
        this.lightPositionGL[this.lightCountGL][3] = 1.0f;
        this.glLightEnable(this.lightCountGL);
        this.glLightAmbient(this.lightCountGL);
        this.glLightPosition(this.lightCountGL);
        this.glLightFalloff(this.lightCountGL);
        this.glLightNoSpot(this.lightCountGL);
        this.glLightNoDiffuse(this.lightCountGL);
        this.glLightNoSpecular(this.lightCountGL);
        ++this.lightCountGL;
    }

    public void directionalLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (!this.glMode) {
            super.directionalLight(f, f2, f3, f4, f5, f6);
            return;
        }
        if (!this.lightsGL) {
            this.glEnableLights();
        }
        if (this.lightCountGL == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuseGL[this.lightCountGL][0] = this.calcR;
        this.lightDiffuseGL[this.lightCountGL][1] = this.calcG;
        this.lightDiffuseGL[this.lightCountGL][2] = this.calcB;
        this.lightDiffuseGL[this.lightCountGL][3] = 1.0f;
        this.lightTypeGL[this.lightCountGL] = 1;
        this.lightFalloffConstantGL[this.lightCountGL] = this.currentLightFalloffConstantGL;
        this.lightFalloffLinearGL[this.lightCountGL] = this.currentLightFalloffLinearGL;
        this.lightFalloffQuadraticGL[this.lightCountGL] = this.currentLightFalloffQuadraticGL;
        this.lightSpecularGL[this.lightCountGL][0] = this.currentLightSpecularGL[0];
        this.lightSpecularGL[this.lightCountGL][1] = this.currentLightSpecularGL[1];
        this.lightSpecularGL[this.lightCountGL][2] = this.currentLightSpecularGL[2];
        this.lightSpecularGL[this.lightCountGL][3] = this.currentLightSpecularGL[3];
        float f7 = 1.0f / PApplet.dist((float)0.0f, (float)0.0f, (float)0.0f, (float)f4, (float)f5, (float)f6);
        this.lightNormalGL[this.lightCountGL][0] = f7 * f4;
        this.lightNormalGL[this.lightCountGL][1] = f7 * f5;
        this.lightNormalGL[this.lightCountGL][2] = f7 * f6;
        this.lightNormalGL[this.lightCountGL][3] = 0.0f;
        this.glLightEnable(this.lightCountGL);
        this.glLightNoAmbient(this.lightCountGL);
        this.glLightDirection(this.lightCountGL);
        this.glLightDiffuse(this.lightCountGL);
        this.glLightSpecular(this.lightCountGL);
        this.glLightFalloff(this.lightCountGL);
        this.glLightNoSpot(this.lightCountGL);
        ++this.lightCountGL;
    }

    public void pointLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (!this.glMode) {
            super.pointLight(f, f2, f3, f4, f5, f6);
            return;
        }
        if (!this.lightsGL) {
            this.glEnableLights();
        }
        if (this.lightCountGL == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuseGL[this.lightCountGL][0] = this.calcR;
        this.lightDiffuseGL[this.lightCountGL][1] = this.calcG;
        this.lightDiffuseGL[this.lightCountGL][2] = this.calcB;
        this.lightDiffuseGL[this.lightCountGL][3] = 1.0f;
        this.lightTypeGL[this.lightCountGL] = 2;
        this.lightFalloffConstantGL[this.lightCountGL] = this.currentLightFalloffConstantGL;
        this.lightFalloffLinearGL[this.lightCountGL] = this.currentLightFalloffLinearGL;
        this.lightFalloffQuadraticGL[this.lightCountGL] = this.currentLightFalloffQuadraticGL;
        this.lightSpecularGL[this.lightCountGL][0] = this.currentLightSpecularGL[0];
        this.lightSpecularGL[this.lightCountGL][1] = this.currentLightSpecularGL[1];
        this.lightSpecularGL[this.lightCountGL][2] = this.currentLightSpecularGL[2];
        this.lightPositionGL[this.lightCountGL][0] = f4;
        this.lightPositionGL[this.lightCountGL][1] = f5;
        this.lightPositionGL[this.lightCountGL][2] = f6;
        this.lightPositionGL[this.lightCountGL][3] = 1.0f;
        this.glLightEnable(this.lightCountGL);
        this.glLightNoAmbient(this.lightCountGL);
        this.glLightPosition(this.lightCountGL);
        this.glLightDiffuse(this.lightCountGL);
        this.glLightSpecular(this.lightCountGL);
        this.glLightFalloff(this.lightCountGL);
        this.glLightNoSpot(this.lightCountGL);
        ++this.lightCountGL;
    }

    public void spotLight(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        if (!this.glMode) {
            super.spotLight(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11);
            return;
        }
        if (!this.lightsGL) {
            this.glEnableLights();
        }
        if (this.lightCountGL == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuseGL[this.lightCountGL][0] = this.calcR;
        this.lightDiffuseGL[this.lightCountGL][1] = this.calcG;
        this.lightDiffuseGL[this.lightCountGL][2] = this.calcB;
        this.lightDiffuseGL[this.lightCountGL][3] = 1.0f;
        this.lightTypeGL[this.lightCountGL] = 3;
        this.lightFalloffConstantGL[this.lightCountGL] = this.currentLightFalloffConstantGL;
        this.lightFalloffLinearGL[this.lightCountGL] = this.currentLightFalloffLinearGL;
        this.lightFalloffQuadraticGL[this.lightCountGL] = this.currentLightFalloffQuadraticGL;
        this.lightSpecularGL[this.lightCountGL][0] = this.currentLightSpecularGL[0];
        this.lightSpecularGL[this.lightCountGL][1] = this.currentLightSpecularGL[1];
        this.lightSpecularGL[this.lightCountGL][2] = this.currentLightSpecularGL[2];
        this.lightPositionGL[this.lightCountGL][0] = f4;
        this.lightPositionGL[this.lightCountGL][1] = f5;
        this.lightPositionGL[this.lightCountGL][2] = f6;
        this.lightPositionGL[this.lightCountGL][3] = 1.0f;
        float f12 = 1.0f / PApplet.dist((float)0.0f, (float)0.0f, (float)0.0f, (float)f7, (float)f8, (float)f9);
        this.lightNormalGL[this.lightCountGL][0] = f12 * f7;
        this.lightNormalGL[this.lightCountGL][1] = f12 * f8;
        this.lightNormalGL[this.lightCountGL][2] = f12 * f9;
        this.lightNormalGL[this.lightCountGL][3] = 0.0f;
        this.lightSpotAngleGL[this.lightCountGL] = PApplet.degrees((float)f10);
        this.lightSpotAngleCosGL[this.lightCountGL] = Math.max(0.0f, (float)Math.cos(f10));
        this.lightSpotConcentrationGL[this.lightCountGL] = f11;
        this.glLightEnable(this.lightCountGL);
        this.glLightNoAmbient(this.lightCountGL);
        this.glLightPosition(this.lightCountGL);
        this.glLightDirection(this.lightCountGL);
        this.glLightDiffuse(this.lightCountGL);
        this.glLightSpecular(this.lightCountGL);
        this.glLightFalloff(this.lightCountGL);
        this.glLightSpotAngle(this.lightCountGL);
        this.glLightSpotConcentration(this.lightCountGL);
        ++this.lightCountGL;
    }

    public void lightFalloff(float f, float f2, float f3) {
        if (!this.glMode) {
            super.lightFalloff(f, f2, f3);
            return;
        }
        this.currentLightFalloffConstantGL = f;
        this.currentLightFalloffLinearGL = f2;
        this.currentLightFalloffQuadraticGL = f3;
    }

    public void lightSpecular(float f, float f2, float f3) {
        if (!this.glMode) {
            super.lightSpecular(f, f2, f3);
            return;
        }
        this.colorCalc(f, f2, f3);
        this.currentLightSpecularGL[0] = this.calcR;
        this.currentLightSpecularGL[1] = this.calcG;
        this.currentLightSpecularGL[2] = this.calcB;
        this.currentLightSpecularGL[3] = 1.0f;
    }

    private void glEnableLights() {
        this.lightsGL = true;
        this.gl.glEnable(2896);
        this.gl.glEnable(2903);
        this.gl.glColorMaterial(1032, 5634);
    }

    private void glDisableLights() {
        this.lightsGL = false;
        this.gl.glDisable(2896);
    }

    private void glLightAmbient(int n) {
        this.gl.glLightfv(16384 + n, 4608, this.lightDiffuseGL[n], 0);
    }

    private void glLightNoAmbient(int n) {
        this.gl.glLightfv(16384 + n, 4608, this.zeroLightGL, 0);
    }

    private void glLightNoSpot(int n) {
        this.gl.glLightf(16384 + n, 4614, 180.0f);
        this.gl.glLightf(16384 + n, 4613, 0.0f);
    }

    private void glLightDiffuse(int n) {
        this.gl.glLightfv(16384 + n, 4609, this.lightDiffuseGL[n], 0);
    }

    private void glLightNoDiffuse(int n) {
        this.gl.glLightfv(16384 + n, 4609, this.zeroLightGL, 0);
    }

    private void glLightDirection(int n) {
        if (this.lightTypeGL[n] == 1) {
            this.gl.glLightfv(16384 + n, 4611, this.lightNormalGL[n], 0);
        } else {
            this.gl.glLightfv(16384 + n, 4612, this.lightNormalGL[n], 0);
        }
    }

    private void glLightEnable(int n) {
        this.gl.glEnable(16384 + n);
    }

    private void glLightDisable(int n) {
        this.gl.glDisable(16384 + n);
    }

    private void glLightFalloff(int n) {
        this.gl.glLightf(16384 + n, 4615, this.lightFalloffConstantGL[n]);
        this.gl.glLightf(16384 + n, 4616, this.lightFalloffLinearGL[n]);
        this.gl.glLightf(16384 + n, 4617, this.lightFalloffQuadraticGL[n]);
    }

    private void glLightPosition(int n) {
        this.gl.glLightfv(16384 + n, 4611, this.lightPositionGL[n], 0);
    }

    private void glLightSpecular(int n) {
        this.gl.glLightfv(16384 + n, 4610, this.lightSpecularGL[n], 0);
    }

    private void glLightNoSpecular(int n) {
        this.gl.glLightfv(16384 + n, 4610, this.zeroLightGL, 0);
    }

    private void glLightSpotAngle(int n) {
        this.gl.glLightf(16384 + n, 4614, this.lightSpotAngleGL[n]);
    }

    private void glLightSpotConcentration(int n) {
        this.gl.glLightf(16384 + n, 4613, this.lightSpotConcentrationGL[n]);
    }

    protected void fillFromCalc() {
        this.fill = true;
        this.fillR = this.calcR;
        this.fillG = this.calcG;
        this.fillB = this.calcB;
        this.fillA = this.calcA;
        this.fillRi = this.calcRi;
        this.fillGi = this.calcGi;
        this.fillBi = this.calcBi;
        this.fillAi = this.calcAi;
        this.fillColor = this.calcColor;
        this.fillAlpha = this.calcAlpha;
        this.ambientR = this.calcR;
        this.ambientG = this.calcG;
        this.ambientB = this.calcB;
        if (this.colorBuffer == null) {
            this.colorBuffer = new float[4];
        }
        this.colorBuffer[0] = this.calcR;
        this.colorBuffer[1] = this.calcG;
        this.colorBuffer[2] = this.calcB;
        this.colorBuffer[3] = this.calcA;
    }

    protected void ambientFromCalc() {
        this.ambientR = this.calcR;
        this.ambientG = this.calcG;
        this.ambientB = this.calcB;
        if (this.colorBuffer == null) {
            this.colorBuffer = new float[4];
        }
        this.colorBuffer[0] = this.calcR;
        this.colorBuffer[1] = this.calcG;
        this.colorBuffer[2] = this.calcB;
        this.colorBuffer[3] = this.calcA;
    }

    public void endCamera() {
        super.endCamera();
        if (this.glMode) {
            this.loadGLModelviewMatrix();
        }
    }

    public void camera() {
        this.camera(this.cameraX, this.cameraY, this.cameraZ, this.cameraX, this.cameraY, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    public void camera(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        super.camera(f, f2, f3, f4, f5, f6, f7, f8, f9);
        if (this.glMode) {
            this.loadGLModelviewMatrix();
        }
    }

    public void ortho() {
        this.ortho(0.0f, this.width, 0.0f, this.height, -10.0f, 10.0f);
    }

    public void ortho(float f, float f2, float f3, float f4, float f5, float f6) {
        super.ortho(f, f2, f3, f4, f5, f6);
        this.gl.glMatrixMode(5888);
    }

    public void perspective() {
        this.perspective(this.cameraFOV, this.cameraAspect, this.cameraNear, this.cameraFar);
    }

    public void perspective(float f, float f2, float f3, float f4) {
        super.perspective(f, f2, f3, f4);
    }

    public void frustum(float f, float f2, float f3, float f4, float f5, float f6) {
        super.frustum(f, f2, f3, f4, f5, f6);
        this.gl.glMatrixMode(5888);
    }

    public void model(GLModel gLModel) {
        gLModel.render();
    }

    public void model(GLModel gLModel, GLModelEffect gLModelEffect) {
        gLModel.render(gLModelEffect);
    }

    public void model(GLModel gLModel, int n, int n2) {
        gLModel.render(n, n2, null);
    }

    public void model(GLModel gLModel, int n, int n2, GLModelEffect gLModelEffect) {
        gLModel.render(n, n2, gLModelEffect);
    }

    public void noBlend() {
        this.glstate.disableBlend();
    }

    public void setDefaultBlend() {
        this.glstate.enableBlend();
        this.glstate.setupDefaultBlending();
    }

    public void setBlendMode(int n) {
        this.glstate.enableBlend();
        this.glstate.setupBlending(n);
    }

    public void clear(int n) {
        int n2 = this.parent.color(n);
        this.glstate.clearColorBuffer(n2);
    }

    public void clear(float f) {
        int n = this.parent.color(f);
        this.glstate.clearColorBuffer(n);
    }

    public void clear(int n, int n2) {
        int n3 = this.parent.color(n, n2);
        this.glstate.clearColorBuffer(n3);
    }

    public void clear(int n, float f) {
        int n2 = this.parent.color((float)n, f);
        this.glstate.clearColorBuffer(n2);
    }

    public void clear(float f, float f2) {
        int n = this.parent.color(f, f2);
        this.glstate.clearColorBuffer(n);
    }

    public void clear(int n, int n2, int n3) {
        int n4 = this.parent.color(n, n2, n3);
        this.glstate.clearColorBuffer(n4);
    }

    public void clear(float f, float f2, float f3) {
        int n = this.parent.color(f, f2, f3);
        this.glstate.clearColorBuffer(n);
    }

    public void clear(int n, int n2, int n3, int n4) {
        int n5 = this.parent.color(n, n2, n3, n4);
        this.glstate.clearColorBuffer(n5);
    }

    public void clear(float f, float f2, float f3, float f4) {
        int n = this.parent.color(f, f2, f3, f4);
        this.glstate.clearColorBuffer(n);
    }

    public void loadPixels() {
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
            this.pixelBuffer = BufferUtil.newIntBuffer((int)this.pixels.length);
        }
        this.colorTex.loadPixels();
    }

    public void loadTexture() {
        this.colorTex.loadTexture();
        PApplet.arrayCopy((Object)this.colorTex.pixels, (Object)this.pixels);
    }

    public void updatePixels() {
        this.colorTex.putBuffer(this.pixels);
    }

    protected void initFramebuffer() {
        this.gl = this.context.getGL();
        this.glstate = new GLState(this.gl);
        this.FBO = new GLFramebufferObject(this.gl);
        this.depthStencilBuffer = GLState.createGLResource(3);
        this.colorTex = new GLTexture(this.parent, this.width, this.height, this.colorTexParams);
        if (this.multisampleEnabled) {
            this.multisampleFBO = new GLFramebufferObject(this.gl);
            this.colorBufferMulti = GLState.createGLResource(3);
            this.gl.glBindRenderbufferEXT(36161, this.colorBufferMulti);
            this.gl.glRenderbufferStorageMultisampleEXT(36161, this.multisampleLevel, 32856, this.width, this.height);
            this.gl.glBindRenderbufferEXT(36161, this.depthStencilBuffer);
            this.gl.glRenderbufferStorageMultisampleEXT(36161, this.multisampleLevel, 35056, this.width, this.height);
            this.glstate.pushFramebuffer();
            this.glstate.setFramebuffer(this.multisampleFBO);
            this.gl.glFramebufferRenderbufferEXT(36160, 36064, 36161, this.colorBufferMulti);
            this.gl.glFramebufferRenderbufferEXT(36160, 36096, 36161, this.depthStencilBuffer);
            this.gl.glFramebufferRenderbufferEXT(36160, 36128, 36161, this.depthStencilBuffer);
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.gl.glClear(17664);
            this.glstate.pushFramebuffer();
            this.glstate.setFramebuffer(this.FBO);
            this.gl.glFramebufferTexture2DEXT(36160, 36064, 3553, this.colorTex.getTextureID(), 0);
            int n = this.gl.glCheckFramebufferStatusEXT(36160);
            GLUtils.printFramebufferError(n);
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.gl.glClear(16384);
            this.glstate.popFramebuffer();
            this.glstate.popFramebuffer();
        } else {
            this.gl.glBindRenderbufferEXT(36161, this.depthStencilBuffer);
            this.gl.glRenderbufferStorageEXT(36161, 35056, this.width, this.height);
            this.glstate.pushFramebuffer();
            this.glstate.setFramebuffer(this.FBO);
            this.gl.glFramebufferTexture2DEXT(36160, 36064, this.colorTex.getTextureTarget(), this.colorTex.getTextureID(), 0);
            this.gl.glFramebufferRenderbufferEXT(36160, 36096, 36161, this.depthStencilBuffer);
            this.gl.glFramebufferRenderbufferEXT(36160, 36128, 36161, this.depthStencilBuffer);
            this.FBO.checkFBO();
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.gl.glClear(17664);
            this.glstate.popFramebuffer();
        }
    }

    protected void releaseFramebuffer() {
        if (this.colorBufferMulti != 0) {
            GLState.deleteGLResource(this.colorBufferMulti, 3);
        }
        if (this.depthStencilBuffer != 0) {
            GLState.deleteGLResource(this.depthStencilBuffer, 3);
        }
    }

    protected void allocate() {
        if (this.glstate == null) {
            PGraphicsOpenGL pGraphicsOpenGL = (PGraphicsOpenGL)this.parent.g;
            if (pGraphicsOpenGL instanceof GLGraphics) {
                this.glcaps = ((GLGraphics)pGraphicsOpenGL).getCapabilities();
                this.mainRenderer = (GLGraphics)pGraphicsOpenGL;
            } else {
                this.glcaps = null;
                this.mainRenderer = null;
            }
            this.context = pGraphicsOpenGL.getContext();
            this.drawable = null;
            this.initFramebuffer();
            this.settingsInited = false;
        } else {
            this.reapplySettings();
        }
    }

    protected void renderTriangles(int n, int n2) {
        this.report("render_triangles in");
        for (int i = n; i < n2; ++i) {
            float[] fArray = this.vertices[this.triangles[i][0]];
            float[] fArray2 = this.vertices[this.triangles[i][1]];
            float[] fArray3 = this.vertices[this.triangles[i][2]];
            float f = this.clamp(this.triangleColors[i][0][0] + this.triangleColors[i][0][4]);
            float f2 = this.clamp(this.triangleColors[i][0][1] + this.triangleColors[i][0][5]);
            float f3 = this.clamp(this.triangleColors[i][0][2] + this.triangleColors[i][0][6]);
            float f4 = this.clamp(this.triangleColors[i][1][0] + this.triangleColors[i][1][4]);
            float f5 = this.clamp(this.triangleColors[i][1][1] + this.triangleColors[i][1][5]);
            float f6 = this.clamp(this.triangleColors[i][1][2] + this.triangleColors[i][1][6]);
            float f7 = this.clamp(this.triangleColors[i][2][0] + this.triangleColors[i][2][4]);
            float f8 = this.clamp(this.triangleColors[i][2][1] + this.triangleColors[i][2][5]);
            float f9 = this.clamp(this.triangleColors[i][2][2] + this.triangleColors[i][2][6]);
            int n3 = this.triangles[i][3];
            if (n3 != -1) {
                GLTexture gLTexture;
                this.report("before enable");
                this.gl.glEnable(3553);
                this.report("after enable");
                float f10 = 1.0f;
                float f11 = 1.0f;
                PImage pImage = this.textures[n3];
                if (pImage instanceof GLTexture) {
                    gLTexture = (GLTexture)pImage;
                    gLTexture.bind(0);
                    f10 *= gLTexture.getMaxTextureCoordS();
                    f11 *= gLTexture.getMaxTextureCoordT();
                    float f12 = 0.0f;
                    float f13 = 1.0f;
                    if (gLTexture.isFlippedX()) {
                        f12 = 1.0f;
                        f13 = -1.0f;
                    }
                    float f14 = 0.0f;
                    float f15 = 1.0f;
                    if (gLTexture.isFlippedY()) {
                        f14 = 1.0f;
                        f15 = -1.0f;
                    }
                    this.gl.glBegin(4);
                    this.gl.glColor4f(f, f2, f3, fArray[6]);
                    this.gl.glTexCoord2f((f12 + f13 * fArray[7]) * f10, (f14 + f15 * fArray[8]) * f11);
                    this.gl.glNormal3f(fArray[9], fArray[10], fArray[11]);
                    this.gl.glEdgeFlag(fArray[12] == 1.0f);
                    this.gl.glVertex3f(fArray[21], fArray[22], fArray[23]);
                    this.gl.glColor4f(f4, f5, f6, fArray2[6]);
                    this.gl.glTexCoord2f((f12 + f13 * fArray2[7]) * f10, (f14 + f15 * fArray2[8]) * f11);
                    this.gl.glNormal3f(fArray2[9], fArray2[10], fArray2[11]);
                    this.gl.glEdgeFlag(fArray[12] == 1.0f);
                    this.gl.glVertex3f(fArray2[21], fArray2[22], fArray2[23]);
                    this.gl.glColor4f(f7, f8, f9, fArray3[6]);
                    this.gl.glTexCoord2f((f12 + f13 * fArray3[7]) * f10, (f14 + f15 * fArray3[8]) * f11);
                    this.gl.glNormal3f(fArray3[9], fArray3[10], fArray3[11]);
                    this.gl.glEdgeFlag(fArray[12] == 1.0f);
                    this.gl.glVertex3f(fArray3[21], fArray3[22], fArray3[23]);
                    this.gl.glEnd();
                    gLTexture.unbind();
                    continue;
                }
                this.report("before bind");
                this.bindTexture(pImage);
                this.report("after bind");
                gLTexture = (PGraphicsOpenGL.ImageCache)pImage.getCache((PGraphics)this);
                f10 = (float)pImage.width / (float)((PGraphicsOpenGL.ImageCache)gLTexture).twidth;
                f11 = (float)pImage.height / (float)((PGraphicsOpenGL.ImageCache)gLTexture).theight;
                this.gl.glBegin(4);
                this.gl.glColor4f(f, f2, f3, fArray[6]);
                this.gl.glTexCoord2f(fArray[7] * f10, fArray[8] * f11);
                this.gl.glNormal3f(fArray[9], fArray[10], fArray[11]);
                this.gl.glEdgeFlag(fArray[12] == 1.0f);
                this.gl.glVertex3f(fArray[21], fArray[22], fArray[23]);
                this.gl.glColor4f(f4, f5, f6, fArray2[6]);
                this.gl.glTexCoord2f(fArray2[7] * f10, fArray2[8] * f11);
                this.gl.glNormal3f(fArray2[9], fArray2[10], fArray2[11]);
                this.gl.glEdgeFlag(fArray[12] == 1.0f);
                this.gl.glVertex3f(fArray2[21], fArray2[22], fArray2[23]);
                this.gl.glColor4f(f7, f8, f9, fArray3[6]);
                this.gl.glTexCoord2f(fArray3[7] * f10, fArray3[8] * f11);
                this.gl.glNormal3f(fArray3[9], fArray3[10], fArray3[11]);
                this.gl.glEdgeFlag(fArray[12] == 1.0f);
                this.gl.glVertex3f(fArray3[21], fArray3[22], fArray3[23]);
                this.gl.glEnd();
                this.report("non-binding 6");
                this.gl.glDisable(3553);
                continue;
            }
            this.gl.glBegin(4);
            this.gl.glColor4f(f, f2, f3, fArray[6]);
            this.gl.glNormal3f(fArray[9], fArray[10], fArray[11]);
            this.gl.glEdgeFlag(fArray[12] == 1.0f);
            this.gl.glVertex3f(fArray[21], fArray[22], fArray[23]);
            this.gl.glColor4f(f4, f5, f6, fArray2[6]);
            this.gl.glNormal3f(fArray2[9], fArray2[10], fArray2[11]);
            this.gl.glEdgeFlag(fArray[12] == 1.0f);
            this.gl.glVertex3f(fArray2[21], fArray2[22], fArray2[23]);
            this.gl.glColor4f(f7, f8, f9, fArray3[6]);
            this.gl.glNormal3f(fArray3[9], fArray3[10], fArray3[11]);
            this.gl.glEdgeFlag(fArray[12] == 1.0f);
            this.gl.glVertex3f(fArray3[21], fArray3[22], fArray3[23]);
            this.gl.glEnd();
        }
        this.report("render_triangles out");
    }

    protected void loadGLModelviewMatrix() {
        this.gl.glMatrixMode(5888);
        this.copyModelviewTM();
        this.gl.glLoadMatrixf(this.modelviewTM, 0);
    }

    protected void multGLModelviewMatrix() {
        this.gl.glMatrixMode(5888);
        this.copyModelviewTM();
        this.gl.glMultMatrixf(this.modelviewTM, 0);
    }

    protected void copyModelviewTM() {
        if (this.modelviewTM == null) {
            this.modelviewTM = new float[16];
        }
        this.modelviewTM[0] = this.modelview.m00;
        this.modelviewTM[1] = this.modelview.m10;
        this.modelviewTM[2] = this.modelview.m20;
        this.modelviewTM[3] = this.modelview.m30;
        this.modelviewTM[4] = this.modelview.m01;
        this.modelviewTM[5] = this.modelview.m11;
        this.modelviewTM[6] = this.modelview.m21;
        this.modelviewTM[7] = this.modelview.m31;
        this.modelviewTM[8] = this.modelview.m02;
        this.modelviewTM[9] = this.modelview.m12;
        this.modelviewTM[10] = this.modelview.m22;
        this.modelviewTM[11] = this.modelview.m32;
        this.modelviewTM[12] = this.modelview.m03;
        this.modelviewTM[13] = this.modelview.m13;
        this.modelviewTM[14] = this.modelview.m23;
        this.modelviewTM[15] = this.modelview.m33;
    }
}

