/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.glgraphics;

import codeanticode.glgraphics.GLConstants;
import codeanticode.glgraphics.GLState;
import codeanticode.glgraphics.GLTexture;
import codeanticode.glgraphics.GLUtils;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import processing.core.PApplet;

public class GLFramebufferObject
implements GLConstants {
    protected GL gl;
    protected int fbo = 0;
    protected int numDrawBuffersInUse;
    int[] colorDrawBuffers;
    int[] textureIDs;
    int[] textureTargets;

    GLFramebufferObject(GL gL, boolean bl) {
        this.gl = gL;
        this.numDrawBuffersInUse = 0;
        if (bl) {
            this.fbo = 0;
        } else if (GLState.fbosAvailable) {
            this.fbo = GLState.createGLResource(2);
        }
    }

    GLFramebufferObject(GL gL) {
        this.gl = gL;
        this.numDrawBuffersInUse = 0;
        if (GLState.fbosAvailable) {
            this.fbo = GLState.createGLResource(2);
        }
    }

    public void delete() {
        if (this.fbo != 0) {
            GLState.deleteGLResource(this.fbo, 2);
            this.fbo = 0;
        }
    }

    public int getFramebufferID() {
        return this.fbo;
    }

    public void checkFBO() {
        if (!GLState.fbosAvailable) {
            return;
        }
        int n = this.gl.glCheckFramebufferStatusEXT(36160);
        GLUtils.printFramebufferError(n);
    }

    void setDrawBuffer(GLTexture gLTexture) {
        this.setDrawBuffers(new GLTexture[]{gLTexture}, 1);
    }

    void setDrawBuffers(GLTexture[] gLTextureArray) {
        this.setDrawBuffers(gLTextureArray, gLTextureArray.length);
    }

    void setDrawBuffers(GLTexture[] gLTextureArray, int n) {
        this.numDrawBuffersInUse = PApplet.min((int)n, (int)gLTextureArray.length);
        this.colorDrawBuffers = new int[this.numDrawBuffersInUse];
        this.textureIDs = new int[this.numDrawBuffersInUse];
        this.textureTargets = new int[this.numDrawBuffersInUse];
        for (int i = 0; i < this.numDrawBuffersInUse; ++i) {
            this.colorDrawBuffers[i] = 36064 + i;
            this.textureTargets[i] = gLTextureArray[i].getTextureTarget();
            this.textureIDs[i] = gLTextureArray[i].getTextureID();
            this.gl.glFramebufferTexture2DEXT(36160, this.colorDrawBuffers[i], this.textureTargets[i], this.textureIDs[i], 0);
        }
        this.checkFBO();
        this.gl.glDrawBuffers(this.numDrawBuffersInUse, IntBuffer.wrap(this.colorDrawBuffers));
    }

    void setDrawBuffer(int n, int n2) {
        this.setDrawBuffers(new int[]{n}, new int[]{n2}, 1);
    }

    void setDrawBuffers(int[] nArray, int[] nArray2) {
        this.setDrawBuffers(nArray, nArray2, PApplet.min((int)nArray.length, (int)nArray2.length));
    }

    void setDrawBuffers(int[] nArray, int[] nArray2, int n) {
        this.numDrawBuffersInUse = PApplet.min((int)n, (int)nArray.length, (int)nArray2.length);
        this.colorDrawBuffers = new int[this.numDrawBuffersInUse];
        this.textureIDs = new int[this.numDrawBuffersInUse];
        this.textureTargets = new int[this.numDrawBuffersInUse];
        for (int i = 0; i < this.numDrawBuffersInUse; ++i) {
            this.colorDrawBuffers[i] = 36064 + i;
            this.textureTargets[i] = nArray[i];
            this.textureIDs[i] = nArray2[i];
            this.gl.glFramebufferTexture2DEXT(36160, this.colorDrawBuffers[i], this.textureTargets[i], this.textureIDs[i], 0);
        }
        this.checkFBO();
        this.gl.glDrawBuffers(this.numDrawBuffersInUse, IntBuffer.wrap(this.colorDrawBuffers));
    }

    void bind() {
        this.gl.glBindFramebufferEXT(36160, this.fbo);
    }
}

