/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.glgraphics;

import codeanticode.glgraphics.GLGraphics;
import codeanticode.glgraphics.GLTexture;
import codeanticode.glgraphics.GLWindow;
import java.awt.Component;
import java.awt.Frame;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;
import processing.core.PApplet;

public class GLTextureWindow
extends GLWindow {
    protected PApplet parent;
    protected String name;
    protected boolean hasBorder;
    protected boolean resizable;
    protected GLRenderer renderer;
    protected GLCanvas canvas;
    protected Frame frame;
    protected GLContext mainContext;
    protected GLCapabilities mainCaps;
    protected GLTexture outTex;
    protected GLGraphics pgl;
    protected boolean restoreVisibility = false;

    public GLTextureWindow(PApplet pApplet, int n, int n2, int n3, int n4) {
        this(pApplet, n, n2, n3, n4, true);
    }

    public GLTextureWindow(PApplet pApplet, int n, int n2, int n3, int n4, boolean bl) {
        this(pApplet, "texture window", n, n2, n3, n4, bl, false, false);
    }

    public GLTextureWindow(PApplet pApplet, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this(pApplet, "texture window", n, n2, n3, n4, bl, bl2, false);
    }

    public GLTextureWindow(PApplet pApplet, String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        this.parent = pApplet;
        this.pgl = (GLGraphics)pApplet.g;
        this.name = string;
        this.x0 = n;
        this.y0 = n2;
        this.width = n3;
        this.height = n4;
        this.visible = bl;
        this.hasBorder = bl2;
        this.resizable = bl3;
        this.initialized = false;
        this.override = false;
        this.outTex = null;
        this.pgl.addWindow(this);
    }

    public void init() {
        if (!this.initialized) {
            this.mainContext = this.pgl.getContext();
            this.mainCaps = this.pgl.getCapabilities();
            this.initImpl(this.x0, this.y0, this.width, this.height);
            this.frame.setVisible(this.visible);
            this.initialized = true;
        } else if (this.mainContext != this.pgl.getContext()) {
            this.mainContext = this.pgl.getContext();
            this.mainCaps = this.pgl.getCapabilities();
            boolean bl = this.frame.isVisible();
            int n = this.frame.getX();
            int n2 = this.frame.getY();
            int n3 = this.frame.getWidth();
            int n4 = this.frame.getHeight();
            this.frame.setVisible(false);
            this.initImpl(n, n2, n3, n4);
            this.restoreVisibility = bl;
        } else if (this.restoreVisibility) {
            this.frame.setVisible(true);
        }
    }

    protected void initImpl(int n, int n2, int n3, int n4) {
        this.frame = new Frame(this.name);
        this.frame.setSize(n3, n4);
        this.frame.setLocation(n, n2);
        if (!this.hasBorder) {
            this.frame.setUndecorated(true);
        } else if (!this.resizable) {
            this.frame.setResizable(false);
        }
        this.canvas = new GLCanvas(this.mainCaps, null, this.mainContext, null);
        this.renderer = new GLRenderer();
        this.canvas.addGLEventListener((GLEventListener)this.renderer);
        this.frame.add((Component)this.canvas);
    }

    public void setTexture(GLTexture gLTexture) {
        this.outTex = gLTexture;
    }

    public void setOverride(boolean bl) {
        this.override = bl;
    }

    public void show() {
        this.frame.setVisible(true);
    }

    public void hide() {
        this.frame.setVisible(false);
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public int getWidth() {
        return this.frame.getWidth();
    }

    public int getHeight() {
        return this.frame.getHeight();
    }

    public int getX() {
        return this.frame.getX();
    }

    public int getY() {
        return this.frame.getY();
    }

    public void tint(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        this.renderer.a = (float)n2 / 255.0f;
        this.renderer.r = (float)n3 / 255.0f;
        this.renderer.g = (float)n4 / 255.0f;
        this.renderer.b = (float)n5 / 255.0f;
    }

    public boolean ready() {
        return this.initialized && this.frame != null && this.renderer != null && this.renderer.initalized;
    }

    public void render() {
        if (this.ready()) {
            this.renderer.started = true;
            this.canvas.display();
        }
    }

    public void setLocation(int n, int n2) {
        this.frame.setLocation(n, n2);
    }

    protected class GLRenderer
    implements GLEventListener {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        GL gl;
        GLContext context;
        boolean initalized = false;
        boolean started = false;

        public void init(GLAutoDrawable gLAutoDrawable) {
            this.gl = gLAutoDrawable.getGL();
            this.context = gLAutoDrawable.getContext();
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.initalized = true;
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            if (!this.initalized || !this.started || GLTextureWindow.this.outTex == null) {
                return;
            }
            int n = gLAutoDrawable.getWidth();
            int n2 = gLAutoDrawable.getHeight();
            this.gl = gLAutoDrawable.getGL();
            this.context = gLAutoDrawable.getContext();
            this.detainContext();
            this.gl.glViewport(0, 0, n, n2);
            this.gl.glMatrixMode(5889);
            this.gl.glLoadIdentity();
            this.gl.glOrtho(0.0, (double)n, 0.0, (double)n2, -100.0, 100.0);
            this.gl.glMatrixMode(5888);
            this.gl.glLoadIdentity();
            float f = GLTextureWindow.this.outTex.getMaxTextureCoordS();
            float f2 = GLTextureWindow.this.outTex.getMaxTextureCoordT();
            float f3 = 0.0f;
            float f4 = 1.0f;
            if (GLTextureWindow.this.outTex.isFlippedX()) {
                f3 = 1.0f;
                f4 = -1.0f;
            }
            float f5 = 0.0f;
            float f6 = 1.0f;
            if (GLTextureWindow.this.outTex.isFlippedY()) {
                f5 = 1.0f;
                f6 = -1.0f;
            }
            this.gl.glClear(16640);
            this.gl.glEnable(GLTextureWindow.this.outTex.getTextureTarget());
            this.gl.glActiveTexture(33984);
            this.gl.glBindTexture(GLTextureWindow.this.outTex.getTextureTarget(), GLTextureWindow.this.outTex.getTextureID());
            this.gl.glColor4f(this.r, this.g, this.b, this.a);
            this.gl.glBegin(7);
            this.gl.glTexCoord2f((f3 + f4 * 0.0f) * f, (f5 + f6 * 1.0f) * f2);
            this.gl.glVertex2f(0.0f, 0.0f);
            this.gl.glTexCoord2f((f3 + f4 * 1.0f) * f, (f5 + f6 * 1.0f) * f2);
            this.gl.glVertex2f((float)n, 0.0f);
            this.gl.glTexCoord2f((f3 + f4 * 1.0f) * f, (f5 + f6 * 0.0f) * f2);
            this.gl.glVertex2f((float)n, (float)n2);
            this.gl.glTexCoord2f((f3 + f4 * 0.0f) * f, (f5 + f6 * 0.0f) * f2);
            this.gl.glVertex2f(0.0f, (float)n2);
            this.gl.glEnd();
            this.gl.glBindTexture(GLTextureWindow.this.outTex.getTextureTarget(), 0);
            this.gl.glFlush();
            this.releaseContext();
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        protected void detainContext() {
            try {
                while (this.context.makeCurrent() == 0) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }

        protected void releaseContext() {
            this.context.release();
        }
    }
}

