/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import processing.core.PApplet;
import processing.xml.StdXMLBuilder;
import processing.xml.StdXMLParser;
import processing.xml.StdXMLReader;
import processing.xml.XMLAttribute;
import processing.xml.XMLException;
import processing.xml.XMLValidator;
import processing.xml.XMLWriter;

public class XMLElement
implements Serializable {
    public static final int NO_LINE = -1;
    private PApplet sketch;
    private XMLElement parent;
    private Vector<XMLAttribute> attributes = new Vector();
    private Vector<XMLElement> children = new Vector(8);
    private String name;
    private String fullName;
    private String namespace;
    private String content;
    private String systemID;
    private int line;

    public XMLElement() {
        this(null, null, null, -1);
    }

    public XMLElement(String fullName) {
        this(fullName, null, null, -1);
    }

    public XMLElement(String fullName, String namespace, String systemID, int lineNr) {
        int index;
        this.fullName = fullName;
        this.name = namespace == null ? fullName : ((index = fullName.indexOf(58)) >= 0 ? fullName.substring(index + 1) : fullName);
        this.namespace = namespace;
        this.content = null;
        this.line = lineNr;
        this.systemID = systemID;
        this.parent = null;
    }

    public XMLElement(PApplet sketch, String filename) {
        this();
        this.sketch = sketch;
        this.init(sketch.createReader(filename));
    }

    public XMLElement(Reader reader) {
        this();
        this.init(reader);
    }

    public static XMLElement parse(String xml) {
        return XMLElement.parse(new StringReader(xml));
    }

    public static XMLElement parse(Reader r) {
        try {
            StdXMLParser parser = new StdXMLParser();
            parser.setBuilder(new StdXMLBuilder());
            parser.setValidator(new XMLValidator());
            parser.setReader(new StdXMLReader(r));
            return (XMLElement)parser.parse();
        }
        catch (XMLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void init(String fullName, String namespace, String systemID, int lineNr) {
        int index;
        this.fullName = fullName;
        this.name = namespace == null ? fullName : ((index = fullName.indexOf(58)) >= 0 ? fullName.substring(index + 1) : fullName);
        this.namespace = namespace;
        this.line = lineNr;
        this.systemID = systemID;
    }

    protected void init(Reader r) {
        try {
            StdXMLParser parser = new StdXMLParser();
            parser.setBuilder(new StdXMLBuilder(this));
            parser.setValidator(new XMLValidator());
            parser.setReader(new StdXMLReader(r));
            parser.parse();
        }
        catch (XMLException e) {
            e.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        this.attributes.clear();
        this.attributes = null;
        this.children = null;
        this.fullName = null;
        this.name = null;
        this.namespace = null;
        this.content = null;
        this.systemID = null;
        this.parent = null;
        super.finalize();
    }

    public XMLElement getParent() {
        return this.parent;
    }

    public String getName() {
        return this.fullName;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setName(String name) {
        this.name = name;
        this.fullName = name;
        this.namespace = null;
    }

    public void setName(String fullName, String namespace) {
        int index = fullName.indexOf(58);
        this.name = namespace == null || index < 0 ? fullName : fullName.substring(index + 1);
        this.fullName = fullName;
        this.namespace = namespace;
    }

    public void addChild(XMLElement child) {
        XMLElement lastChild;
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (child.getLocalName() == null && !this.children.isEmpty() && (lastChild = this.children.lastElement()).getLocalName() == null) {
            lastChild.setContent(String.valueOf(lastChild.getContent()) + child.getContent());
            return;
        }
        child.parent = this;
        this.children.addElement(child);
    }

    public void insertChild(XMLElement child, int index) {
        XMLElement lastChild;
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (child.getLocalName() == null && !this.children.isEmpty() && (lastChild = this.children.lastElement()).getLocalName() == null) {
            lastChild.setContent(String.valueOf(lastChild.getContent()) + child.getContent());
            return;
        }
        child.parent = this;
        this.children.insertElementAt(child, index);
    }

    public void removeChild(XMLElement child) {
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        this.children.removeElement(child);
    }

    public void removeChild(int index) {
        this.children.removeElementAt(index);
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int getChildCount() {
        return this.children.size();
    }

    public String[] listChildren() {
        int childCount = this.getChildCount();
        String[] outgoing = new String[childCount];
        int i = 0;
        while (i < childCount) {
            outgoing[i] = this.getChild(i).getName();
            ++i;
        }
        return outgoing;
    }

    public XMLElement[] getChildren() {
        int childCount = this.getChildCount();
        Object[] kids = new XMLElement[childCount];
        this.children.copyInto(kids);
        return kids;
    }

    public XMLElement getChild(int index) {
        return this.children.elementAt(index);
    }

    public XMLElement getChild(String path) {
        if (path.indexOf(47) != -1) {
            return this.getChildRecursive(PApplet.split(path, '/'), 0);
        }
        int childCount = this.getChildCount();
        int i = 0;
        while (i < childCount) {
            XMLElement kid = this.getChild(i);
            String kidName = kid.getName();
            if (kidName != null && kidName.equals(path)) {
                return kid;
            }
            ++i;
        }
        return null;
    }

    protected XMLElement getChildRecursive(String[] items, int offset) {
        if (Character.isDigit(items[offset].charAt(0))) {
            XMLElement kid = this.getChild(Integer.parseInt(items[offset]));
            if (offset == items.length - 1) {
                return kid;
            }
            return kid.getChildRecursive(items, offset + 1);
        }
        int childCount = this.getChildCount();
        int i = 0;
        while (i < childCount) {
            XMLElement kid = this.getChild(i);
            String kidName = kid.getName();
            if (kidName != null && kidName.equals(items[offset])) {
                if (offset == items.length - 1) {
                    return kid;
                }
                return kid.getChildRecursive(items, offset + 1);
            }
            ++i;
        }
        return null;
    }

    public XMLElement[] getChildren(String path) {
        if (path.indexOf(47) != -1) {
            return this.getChildrenRecursive(PApplet.split(path, '/'), 0);
        }
        if (Character.isDigit(path.charAt(0))) {
            return new XMLElement[]{this.getChild(Integer.parseInt(path))};
        }
        int childCount = this.getChildCount();
        XMLElement[] matches = new XMLElement[childCount];
        int matchCount = 0;
        int i = 0;
        while (i < childCount) {
            XMLElement kid = this.getChild(i);
            String kidName = kid.getName();
            if (kidName != null && kidName.equals(path)) {
                matches[matchCount++] = kid;
            }
            ++i;
        }
        return (XMLElement[])PApplet.subset(matches, 0, matchCount);
    }

    protected XMLElement[] getChildrenRecursive(String[] items, int offset) {
        if (offset == items.length - 1) {
            return this.getChildren(items[offset]);
        }
        XMLElement[] matches = this.getChildren(items[offset]);
        XMLElement[] outgoing = new XMLElement[]{};
        int i = 0;
        while (i < matches.length) {
            XMLElement[] kidMatches = matches[i].getChildrenRecursive(items, offset + 1);
            outgoing = (XMLElement[])PApplet.concat(outgoing, kidMatches);
            ++i;
        }
        return outgoing;
    }

    private XMLAttribute findAttribute(String fullName) {
        Enumeration<XMLAttribute> en = this.attributes.elements();
        while (en.hasMoreElements()) {
            XMLAttribute attr = en.nextElement();
            if (!attr.getName().equals(fullName)) continue;
            return attr;
        }
        return null;
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String[] listAttributes() {
        String[] outgoing = new String[this.attributes.size()];
        int i = 0;
        while (i < this.attributes.size()) {
            outgoing[i] = this.attributes.get(i).getName();
            ++i;
        }
        return outgoing;
    }

    public String getStringAttribute(String name) {
        return this.getString(name);
    }

    public String getStringAttribute(String name, String defaultValue) {
        return this.getString(name, defaultValue);
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public String getString(String name, String defaultValue) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getValue();
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.getString(name);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("1") || value.toLowerCase().equals("true");
    }

    public int getIntAttribute(String name) {
        return this.getInt(name, 0);
    }

    public int getIntAttribute(String name, int defaultValue) {
        return this.getInt(name, defaultValue);
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int defaultValue) {
        String value = this.getString(name);
        return value == null ? defaultValue : PApplet.parseInt(value, defaultValue);
    }

    public float getFloatAttribute(String name) {
        return this.getFloat(name, 0.0f);
    }

    public float getFloatAttribute(String name, float defaultValue) {
        return this.getFloat(name, 0.0f);
    }

    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    public float getFloat(String name, float defaultValue) {
        String value = this.getString(name);
        if (value == null) {
            return defaultValue;
        }
        return PApplet.parseFloat(value, defaultValue);
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public double getDouble(String name, double defaultValue) {
        String value = this.getString(name);
        return value == null ? defaultValue : Double.parseDouble(value);
    }

    public void setString(String name, String value) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            attr = new XMLAttribute(name, name, null, value, "CDATA");
            this.attributes.addElement(attr);
        } else {
            attr.setValue(value);
        }
    }

    public void setBoolean(String name, boolean value) {
        this.setString(name, String.valueOf(value));
    }

    public void setInt(String name, int value) {
        this.setString(name, String.valueOf(value));
    }

    public void setFloat(String name, float value) {
        this.setString(name, String.valueOf(value));
    }

    public void setDouble(String name, double value) {
        this.setString(name, String.valueOf(value));
    }

    public void remove(String name) {
        int i = 0;
        while (i < this.attributes.size()) {
            XMLAttribute attr = this.attributes.elementAt(i);
            if (attr.getName().equals(name)) {
                this.attributes.removeElementAt(i);
                return;
            }
            ++i;
        }
    }

    public boolean hasAttribute(String name) {
        return this.findAttribute(name) != null;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public int getLine() {
        return this.line;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean equals(Object object) {
        if (!(object instanceof XMLElement)) {
            return false;
        }
        XMLElement rawElement = (XMLElement)object;
        if (!this.name.equals(rawElement.getLocalName())) {
            return false;
        }
        if (this.attributes.size() != rawElement.getAttributeCount()) {
            return false;
        }
        Enumeration<XMLAttribute> en = this.attributes.elements();
        while (en.hasMoreElements()) {
            XMLAttribute attr = en.nextElement();
            if (!rawElement.hasAttribute(attr.getName())) {
                return false;
            }
            String value = rawElement.getString(attr.getName(), null);
            if (attr.getValue().equals(value)) continue;
            return false;
        }
        if (this.children.size() != rawElement.getChildCount()) {
            return false;
        }
        int i = 0;
        while (i < this.children.size()) {
            XMLElement child2;
            XMLElement child1 = this.getChild(i);
            if (!child1.equals(child2 = rawElement.getChild(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean pretty) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(baos);
        XMLWriter writer = new XMLWriter(osw);
        try {
            writer.write(this, pretty);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toString();
    }

    private PApplet findSketch() {
        if (this.sketch != null) {
            return this.sketch;
        }
        if (this.parent != null) {
            return this.parent.findSketch();
        }
        return null;
    }

    public boolean save(String filename) {
        if (this.sketch == null) {
            this.sketch = this.findSketch();
        }
        if (this.sketch == null) {
            System.err.println("save() can only be used on elements loaded by a sketch");
            throw new RuntimeException("no sketch found, use write(PrintWriter) instead.");
        }
        return this.write(this.sketch.createWriter(filename));
    }

    public boolean write(PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        XMLWriter xmlw = new XMLWriter(writer);
        try {
            xmlw.write(this, true);
            writer.flush();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

