/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.glgraphics;

import codeanticode.glgraphics.GLConstants;
import codeanticode.glgraphics.GLShader;
import javax.media.opengl.GL;
import processing.core.PApplet;
import processing.opengl.PGraphicsOpenGL;

abstract class GLShaderVariable
implements GLConstants {
    protected GL gl;
    protected GLShader shader;
    protected String name;
    protected String label;
    protected int type;
    protected int valueInt;
    protected float valueFloat;
    protected float[] valueArray;
    protected PApplet parent;
    protected int arrayLength;

    public GLShaderVariable() {
        this.gl = null;
        this.shader = null;
        this.parent = null;
        this.name = "";
        this.type = 0;
        this.label = "";
        this.arrayLength = 0;
    }

    public GLShaderVariable(PApplet pApplet, String string, String string2, int n, int n2) {
        this(pApplet, null, string, string2, n, n2);
    }

    public GLShaderVariable(PApplet pApplet, GLShader gLShader, String string, String string2, int n, int n2) {
        PGraphicsOpenGL pGraphicsOpenGL = (PGraphicsOpenGL)pApplet.g;
        this.gl = pGraphicsOpenGL.gl;
        this.shader = gLShader;
        this.parent = pApplet;
        this.name = string;
        this.type = n;
        this.label = string2;
        this.arrayLength = n2;
        this.allocateValueArray();
    }

    public void setShader(GLShader gLShader) {
        this.shader = gLShader;
    }

    public abstract boolean available();

    public abstract void init();

    public void setValue(int n) {
        if (this.type == 0) {
            this.valueInt = n;
        } else {
            System.err.println("Error in shader variable " + this.name + ": Wrong type.");
        }
    }

    public void setValue(float f) {
        if (this.type == 1) {
            this.valueFloat = f;
        } else {
            System.err.println("Error in shader variable " + this.name + ": Wrong type.");
        }
    }

    public void setValue(float[] fArray) {
        int n = fArray.length;
        if (n == 1 && (this.type == 0 || this.type == 1)) {
            if (this.type == 0) {
                this.valueInt = (int)fArray[0];
            } else {
                this.valueFloat = fArray[0];
            }
        } else if (n == 2 && this.type == 2 || n == 3 && this.type == 3 || n == 4 && this.type == 4 || n == 4 && this.type == 5 || n == 9 && this.type == 6 || n == 16 && this.type == 7 || n == this.arrayLength && this.type == 8) {
            PApplet.arrayCopy((Object)fArray, (Object)this.valueArray);
        } else {
            System.err.println("Error in shader variable " + this.name + ": Wrong type.");
        }
    }

    public void setValue(int n, float f) {
        if (n < 2 && this.type == 2 || n < 3 && this.type == 3 || n < 4 && this.type == 4 || n < 4 && this.type == 5 || n < 9 && this.type == 6 || n < 16 && this.type == 7 || n < this.arrayLength && this.type == 8) {
            this.valueArray[n] = f;
        } else {
            System.err.println("Error in shader variable " + this.name + ": Wrong type.");
        }
    }

    public void setValue(int n, int n2, float f) {
        if (n < 2 && n2 < 2 && this.type == 5) {
            this.valueArray[2 * n + n2] = f;
        } else if (n < 3 && n2 < 3 && this.type == 6) {
            this.valueArray[3 * n + n2] = f;
        } else if (n < 4 && n2 < 4 && this.type == 6) {
            this.valueArray[4 * n + n2] = f;
        } else {
            System.err.println("Error in shader variable " + this.name + ": Wrong type.");
        }
    }

    public abstract void copyToShader();

    public static int getType(String string) {
        if (string.equals("int")) {
            return 0;
        }
        if (string.equals("float")) {
            return 1;
        }
        if (string.equals("vec2")) {
            return 2;
        }
        if (string.equals("vec3")) {
            return 3;
        }
        if (string.equals("vec4")) {
            return 4;
        }
        if (string.equals("mat2")) {
            return 5;
        }
        if (string.equals("mat3")) {
            return 6;
        }
        if (string.equals("mat4")) {
            return 7;
        }
        if (string.equals("texsampler")) {
            return 9;
        }
        if (string.equals("modelview")) {
            return 10;
        }
        if (string.equals("projection")) {
            return 11;
        }
        if (string.equals("modelview_projection")) {
            return 12;
        }
        if (string.equals("texmatrix")) {
            return 13;
        }
        if (string.equals("array")) {
            return 8;
        }
        return -1;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }

    protected void allocateValueArray() {
        this.valueArray = this.type == 2 ? new float[2] : (this.type == 3 ? new float[3] : (this.type == 4 ? new float[4] : (this.type == 5 ? new float[4] : (this.type == 6 ? new float[9] : (this.type == 7 ? new float[16] : (float[])(this.type == 8 ? new float[this.arrayLength] : null))))));
    }
}

