/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;

public class Java2D {
    private static boolean DEBUG = Debug.debug("Java2D");
    private static boolean VERBOSE = Debug.verbose();
    private static boolean isHeadless;
    private static boolean isOGLPipelineActive;
    private static Method invokeWithOGLContextCurrentMethod;
    private static Method isQueueFlusherThreadMethod;
    private static Method getOGLViewportMethod;
    private static Method getOGLScissorBoxMethod;
    private static Method getOGLSurfaceIdentifierMethod;
    private static Method getOGLTextureTypeMethod;
    private static boolean fbObjectSupportInitialized;
    private static Method invokeWithOGLSharedContextCurrentMethod;
    private static Method getOGLSurfaceTypeMethod;
    public static final int UNDEFINED;
    public static final int WINDOW;
    public static final int PBUFFER;
    public static final int TEXTURE;
    public static final int FLIP_BACKBUFFER;
    public static final int FBOBJECT;
    private static boolean initializedJ2DFBOShareContext;
    private static GLContext j2dFBOShareContext;
    private static Method createOGLContextOnSurfaceMethod;
    private static Method makeOGLContextCurrentOnSurfaceMethod;
    private static Method destroyOGLContextMethod;
    static /* synthetic */ Class class$java$awt$Graphics;
    static /* synthetic */ Class class$java$lang$Runnable;
    static /* synthetic */ Class class$java$awt$GraphicsConfiguration;

    public static boolean isOGLPipelineActive() {
        return isOGLPipelineActive;
    }

    public static boolean isFBOEnabled() {
        return fbObjectSupportInitialized;
    }

    public static boolean isQueueFlusherThread() {
        Java2D.checkActive();
        try {
            return (Boolean)isQueueFlusherThreadMethod.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeWithOGLContextCurrent(Graphics graphics, Runnable runnable) throws GLException {
        Java2D.checkActive();
        try {
            Java2D.initFBOShareContext(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
            GLDrawableFactoryImpl.getFactoryImpl().lockAWTForJava2D();
            try {
                invokeWithOGLContextCurrentMethod.invoke(null, graphics, runnable);
            }
            finally {
                GLDrawableFactoryImpl.getFactoryImpl().unlockAWTForJava2D();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean invokeWithOGLSharedContextCurrent(GraphicsConfiguration graphicsConfiguration, Runnable runnable) throws GLException {
        Java2D.checkActive();
        GLDrawableFactoryImpl.getFactoryImpl().lockAWTForJava2D();
        try {
            boolean bl = (Boolean)invokeWithOGLSharedContextCurrentMethod.invoke(null, graphicsConfiguration, runnable);
            GLDrawableFactoryImpl.getFactoryImpl().unlockAWTForJava2D();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                GLDrawableFactoryImpl.getFactoryImpl().unlockAWTForJava2D();
                throw throwable;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new GLException(invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw (InternalError)new InternalError().initCause(exception);
            }
        }
    }

    public static Rectangle getOGLViewport(Graphics graphics, int n, int n2) {
        Java2D.checkActive();
        try {
            return (Rectangle)getOGLViewportMethod.invoke(null, graphics, new Integer(n), new Integer(n2));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static Rectangle getOGLScissorBox(Graphics graphics) {
        Java2D.checkActive();
        try {
            return (Rectangle)getOGLScissorBoxMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static Object getOGLSurfaceIdentifier(Graphics graphics) {
        Java2D.checkActive();
        try {
            return getOGLSurfaceIdentifierMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static int getOGLSurfaceType(Graphics graphics) {
        Java2D.checkActive();
        try {
            if (!fbObjectSupportInitialized) {
                return 0;
            }
            return (Integer)getOGLSurfaceTypeMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static int getOGLTextureType(Graphics graphics) {
        Java2D.checkActive();
        if (getOGLTextureTypeMethod == null) {
            return 3553;
        }
        try {
            return (Integer)getOGLTextureTypeMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static GLContext filterShareContext(GLContext gLContext) {
        if (isHeadless) {
            return gLContext;
        }
        Java2D.initFBOShareContext(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        if (j2dFBOShareContext != null) {
            return j2dFBOShareContext;
        }
        return gLContext;
    }

    public static GLContext getShareContext(GraphicsConfiguration graphicsConfiguration) {
        Java2D.initFBOShareContext(graphicsConfiguration);
        return j2dFBOShareContext;
    }

    public static long createOGLContextOnSurface(Graphics graphics, long l) {
        Java2D.checkActive();
        try {
            return (Long)createOGLContextOnSurfaceMethod.invoke(null, graphics, new Long(l));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static boolean makeOGLContextCurrentOnSurface(Graphics graphics, long l) {
        Java2D.checkActive();
        try {
            return (Boolean)makeOGLContextCurrentOnSurfaceMethod.invoke(null, graphics, new Long(l));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static void destroyOGLContext(long l) {
        Java2D.checkActive();
        try {
            destroyOGLContextMethod.invoke(null, new Long(l));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    private static void checkActive() {
        if (!Java2D.isOGLPipelineActive()) {
            throw new GLException("Java2D OpenGL pipeline not active (or necessary support not present)");
        }
    }

    private static int getOGLUtilitiesIntField(final String string) {
        Integer n = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName("sun.java2d.opengl.OGLUtilities");
                    Field field = clazz.getField(string);
                    field.setAccessible(true);
                    return field.get(null);
                }
                catch (Exception exception) {
                    if (DEBUG && VERBOSE) {
                        exception.printStackTrace();
                    }
                    return null;
                }
            }
        });
        if (n == null) {
            return 0;
        }
        if (DEBUG && VERBOSE) {
            System.err.println("OGLUtilities." + string + " = " + n);
        }
        return n;
    }

    private static void initFBOShareContext(GraphicsConfiguration graphicsConfiguration) {
        if (Java2D.isOGLPipelineActive() && Java2D.isFBOEnabled() && !initializedJ2DFBOShareContext) {
            initializedJ2DFBOShareContext = true;
            if (DEBUG) {
                System.err.println("Starting initialization of J2D FBO share context");
            }
            Java2D.invokeWithOGLSharedContextCurrent(graphicsConfiguration, new Runnable(){

                public void run() {
                    j2dFBOShareContext = GLDrawableFactory.getFactory().createExternalGLContext();
                }
            });
            if (DEBUG) {
                System.err.println("Ending initialization of J2D FBO share context");
            }
        }
    }

    static {
        UNDEFINED = Java2D.getOGLUtilitiesIntField("UNDEFINED");
        WINDOW = Java2D.getOGLUtilitiesIntField("WINDOW");
        PBUFFER = Java2D.getOGLUtilitiesIntField("PBUFFER");
        TEXTURE = Java2D.getOGLUtilitiesIntField("TEXTURE");
        FLIP_BACKBUFFER = Java2D.getOGLUtilitiesIntField("FLIP_BACKBUFFER");
        FBOBJECT = Java2D.getOGLUtilitiesIntField("FBOBJECT");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block15: {
                    if (DEBUG && VERBOSE) {
                        System.err.println("Checking for Java2D/OpenGL support");
                    }
                    try {
                        isHeadless = true;
                        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                        isHeadless = false;
                        String string = graphicsConfiguration.getClass().getName();
                        if (DEBUG && VERBOSE) {
                            System.err.println("Java2D support: default GraphicsConfiguration = " + string);
                        }
                        isOGLPipelineActive = string.startsWith("sun.java2d.opengl");
                        if (!isOGLPipelineActive) break block15;
                        try {
                            Class<?> clazz;
                            block18: {
                                block17: {
                                    Class<?> clazz2;
                                    block16: {
                                        clazz2 = Class.forName("sun.java2d.opengl.OGLUtilities");
                                        invokeWithOGLContextCurrentMethod = clazz2.getDeclaredMethod("invokeWithOGLContextCurrent", class$java$awt$Graphics == null ? (class$java$awt$Graphics = Java2D.class$("java.awt.Graphics")) : class$java$awt$Graphics, class$java$lang$Runnable == null ? (class$java$lang$Runnable = Java2D.class$("java.lang.Runnable")) : class$java$lang$Runnable);
                                        invokeWithOGLContextCurrentMethod.setAccessible(true);
                                        isQueueFlusherThreadMethod = clazz2.getDeclaredMethod("isQueueFlusherThread", new Class[0]);
                                        isQueueFlusherThreadMethod.setAccessible(true);
                                        getOGLViewportMethod = clazz2.getDeclaredMethod("getOGLViewport", class$java$awt$Graphics == null ? (class$java$awt$Graphics = Java2D.class$("java.awt.Graphics")) : class$java$awt$Graphics, Integer.TYPE, Integer.TYPE);
                                        getOGLViewportMethod.setAccessible(true);
                                        getOGLScissorBoxMethod = clazz2.getDeclaredMethod("getOGLScissorBox", class$java$awt$Graphics == null ? (class$java$awt$Graphics = Java2D.class$("java.awt.Graphics")) : class$java$awt$Graphics);
                                        getOGLScissorBoxMethod.setAccessible(true);
                                        getOGLSurfaceIdentifierMethod = clazz2.getDeclaredMethod("getOGLSurfaceIdentifier", class$java$awt$Graphics == null ? (class$java$awt$Graphics = Java2D.class$("java.awt.Graphics")) : class$java$awt$Graphics);
                                        getOGLSurfaceIdentifierMethod.setAccessible(true);
                                        fbObjectSupportInitialized = true;
                                        try {
                                            invokeWithOGLSharedContextCurrentMethod = clazz2.getDeclaredMethod("invokeWithOGLSharedContextCurrent", class$java$awt$GraphicsConfiguration == null ? (class$java$awt$GraphicsConfiguration = Java2D.class$("java.awt.GraphicsConfiguration")) : class$java$awt$GraphicsConfiguration, class$java$lang$Runnable == null ? (class$java$lang$Runnable = Java2D.class$("java.lang.Runnable")) : class$java$lang$Runnable);
                                            invokeWithOGLSharedContextCurrentMethod.setAccessible(true);
                                            getOGLSurfaceTypeMethod = clazz2.getDeclaredMethod("getOGLSurfaceType", class$java$awt$Graphics == null ? (class$java$awt$Graphics = Java2D.class$("java.awt.Graphics")) : class$java$awt$Graphics);
                                            getOGLSurfaceTypeMethod.setAccessible(true);
                                        }
                                        catch (Exception exception) {
                                            fbObjectSupportInitialized = false;
                                            if (!DEBUG || !VERBOSE) break block16;
                                            exception.printStackTrace();
                                            System.err.println("Disabling Java2D/JOGL FBO support");
                                        }
                                    }
                                    try {
                                        getOGLTextureTypeMethod = clazz2.getDeclaredMethod("getOGLTextureType", class$java$awt$Graphics == null ? (class$java$awt$Graphics = Java2D.class$("java.awt.Graphics")) : class$java$awt$Graphics);
                                        getOGLTextureTypeMethod.setAccessible(true);
                                    }
                                    catch (Exception exception) {
                                        if (!DEBUG || !VERBOSE) break block17;
                                        exception.printStackTrace();
                                        System.err.println("GL_ARB_texture_rectangle FBO support disabled");
                                    }
                                }
                                clazz = null;
                                try {
                                    clazz = Class.forName("sun.java2d.opengl.CGLSurfaceData");
                                }
                                catch (Exception exception) {
                                    if (!DEBUG || !VERBOSE) break block18;
                                    exception.printStackTrace();
                                    System.err.println("Unable to find class sun.java2d.opengl.CGLSurfaceData for OS X");
                                }
                            }
                            if (clazz != null) {
                                fbObjectSupportInitialized = false;
                                createOGLContextOnSurfaceMethod = clazz.getDeclaredMethod("createOGLContextOnSurface", class$java$awt$Graphics == null ? (class$java$awt$Graphics = Java2D.class$("java.awt.Graphics")) : class$java$awt$Graphics, Long.TYPE);
                                createOGLContextOnSurfaceMethod.setAccessible(true);
                                makeOGLContextCurrentOnSurfaceMethod = clazz.getDeclaredMethod("makeOGLContextCurrentOnSurface", class$java$awt$Graphics == null ? (class$java$awt$Graphics = Java2D.class$("java.awt.Graphics")) : class$java$awt$Graphics, Long.TYPE);
                                makeOGLContextCurrentOnSurfaceMethod.setAccessible(true);
                                destroyOGLContextMethod = clazz.getDeclaredMethod("destroyOGLContext", Long.TYPE);
                                destroyOGLContextMethod.setAccessible(true);
                            }
                        }
                        catch (Exception exception) {
                            if (DEBUG && VERBOSE) {
                                exception.printStackTrace();
                                System.err.println("Disabling Java2D/JOGL integration");
                            }
                            isOGLPipelineActive = false;
                        }
                    }
                    catch (HeadlessException headlessException) {
                        // empty catch block
                    }
                }
                if (DEBUG) {
                    System.err.println("JOGL/Java2D integration " + (isOGLPipelineActive ? "enabled" : "disabled"));
                }
                return null;
            }
        });
    }
}

