/// tex, tex2 need to be send here from opengl
uniform sampler2D tex, tex2;
uniform float time;

/// varying == sended by oter shader (*.vert)
varying vec3 normal;
varying vec4 vertex;



float getLight(){
	float r= 1.0;
	normal= vec3(texture2D(tex2,gl_TexCoord[1].st));
	//normal= vec3( 1.0, 0.0, 0.0 );
	//r= dot( normalize(-gl_LightSource[0].spotDirection), normalize(normal) );
	//r= dot( normalize(-gl_LightSource[0].spotDirection), normalize(gl_NormalMatrix*normal) );
	//r= dot( normalize(-gl_LightSource[0].spotDirection), normalize(vec3(gl_ModelViewProjectionMatrix*vec4(normal,1.0)-vertex)) );
	vec4 n= vec4( normal, 1.0 );
	n+= vertex;
	n*=gl_ModelViewProjectionMatrix;
	n-= gl_ModelViewProjectionMatrix*vertex;
	
	r= dot( vec3( 0.0, 0.0, 1.0), vec3(n) );
	
	return r;
}



vec4 getColor(){
	vec4 color= vec4( 0.0, 0.0, 0.0, 0.0);
	color += texture2D(tex,gl_TexCoord[0].st);
	color= vec4( 1.0, 1.0, 1.0, 0.0);
	return color;
}



void main( )
{
	float light= getLight();
	vec4 color= getColor();
	
	vec4 o= vec4( 0.0, 0.0, 0.0, 1.0 );
	o= light*color;
	//o= color;
	
	if( o[0]<0.0 || o[1]<0.0 || o[2]<0.0 )
		gl_FragColor= vec4( 0.0, 1.0, 0.0, 1.0);
	else if( o[0]>1.0 || o[1]>1.0 || o[2]>1.0 )
		gl_FragColor= vec4( 0.0, 0.0, 1.0, 1.0);
	else
		gl_FragColor= o;
}
