#version 330 core

uniform sampler2D particle;
uniform sampler2D normal_depth;
uniform vec2 viewport;

in vec2 uv;
in float alpha;
in vec3 ec_pos;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_include.frag>

void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = texture(normal_depth, uv_pos).w;
	vec3 pos = calc_position(uv_pos, d);

	//if ( pos.z > ec_pos.z ) discard;

	float a = alpha * clamp(ec_pos.z - pos.z, 0.0, 1.0);

	frag_color.rgb = texture(particle, uv).rgb * vec3(0.8, 0.9, 1.0) * a;
	frag_color.a = 0.0;
}
