
void applyForces(inout vec3 pos, inout vec3 oldPos, in vec3 force, float timeSqr)
{
	vec3 tmp = pos;
	pos += (pos - oldPos) + force*timeSqr;
	oldPos = tmp;
}


void applyConstraints(inout vec3 posA, in vec3 posB, float restLength, float active)
{
	vec3 diff = posB - posA;
	float len = length(diff);
	diff *= ((len - restLength) / len) * 0.5;
	posA += diff*active;
}

