
vec3 calculate_phong_model(in vec3 n, in vec3 l, in vec3 e, in float specularPower)
{
	vec3 r = reflect(l, n);
	float diffTerm = max(dot(n, l), 0.0);
	float specTerm = pow(max(dot(e, r), 0.0), specularPower)*diffTerm;
	return vec3(diffTerm, specTerm, 1.0);	
}


