#version 330 core

// #define USE_GAUSS_BLUR

uniform sampler2D edge_buffer;
uniform sampler2D color_buffer;
uniform vec2 TexelSize;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

void main()
{
	vec4 color = vec4(0.0);

	vec4 original_color = texture(color_buffer, uv);

	float edge_factor = texture(edge_buffer, uv).r;

#ifdef USE_GAUSS_BLUR
	// 3x3 gauss blur
	color += texture(color_buffer, uv+vec2(-TexelSize.x, TexelSize.y));
	color += texture(color_buffer, uv+vec2(0.0, TexelSize.y)) * 2.0;
	color += texture(color_buffer, uv+TexelSize);

	color += texture(color_buffer, uv+vec2(-TexelSize.x, 0.0)) * 2.0;
	color += original_color * 4.0;
	color += texture(color_buffer, uv+vec2(TexelSize.x, 0.0)) * 2.0;

	color += texture(color_buffer, uv-vec2(-TexelSize.x, TexelSize.y));
	color += texture(color_buffer, uv-vec2(0.0, TexelSize.y)) * 2.0;
	color += texture(color_buffer, uv-TexelSize);

	color *= 1.0 / 16.0;
#else // !USE_GAUSS_BLUR
	// 3x3 box blur
	color += texture(color_buffer, uv+vec2(-TexelSize.x, TexelSize.y));
	color += texture(color_buffer, uv+vec2(0.0, TexelSize.y));
	color += texture(color_buffer, uv+TexelSize);

	color += texture(color_buffer, uv+vec2(-TexelSize.x, 0.0));
	color += original_color;
	color += texture(color_buffer, uv+vec2(TexelSize.x, 0.0));

	color += texture(color_buffer, uv-vec2(-TexelSize.x, TexelSize.y));
	color += texture(color_buffer, uv-vec2(0.0, TexelSize.y));
	color += texture(color_buffer, uv-TexelSize);

	color *= 1.0 / 9.0;
#endif

	frag_color = mix(original_color, color, edge_factor);
	//frag_color = vec4(original_color);
	//frag_color = vec4(edge_factor);
}
