#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat3 NormalMatrix;
uniform sampler2D pincushion_coord;
uniform float boxScale;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec3 normal;
out vec2 uv;
out vec2 pos_zw;

#include <pincushion/pincushion_include.vert>


void main()
{
	vec2 offset, depth_uv;
	getPincushionOffsetUV(offset, depth_uv);
#if 0
	vec4 pc = texture(pincushion_coord, depth_uv);
#else
	vec4 pc = bilinear_sampling(pincushion_coord, depth_uv);
#endif

	//vec3 pos = POSITION*pc.w*0.125 + pc.xyz;
	vec3 pos = POSITION*pc.w*boxScale + pc.xyz;

	uv = TEXCOORD;
	normal = NormalMatrix * NORMAL;

	vec4 proj_pos = ModelViewProjectionMatrix * vec4(pos, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
