#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 WorldMatrix;
uniform mat3 NormalMatrix;

uniform vec4 vortex_params; // <radius, angle> ,  <radius, angle>
uniform float time;

in vec3 POSITION;
in vec3 NORMAL;
out vec4 coord;

#include <pincushion/deforms_include.vert>

void main()
{
	float len = length(POSITION);
	float extScale = 0.25 + sin(len*3.14 - time*4.0)*0.25;
	vec3 extrudePos = POSITION + NORMAL*extScale;
	vec3 pos = vortex_y(extrudePos, vec3(0.0), vortex_params.x, vortex_params.y);
	pos = vortex_z(pos, vec3(0.0), vortex_params.z, vortex_params.w);

	vec3 n = normalize(NormalMatrix * NORMAL);

	coord.xyz = vec3(WorldMatrix * vec4(pos, 1.0));
	coord.w = 0.25 + 0.75*abs(dot(n, vec3(0.0, 0.0, 1.0)));

	gl_Position = ModelViewProjectionMatrix * vec4(pos, 1.0);
}
