#version 330 core

uniform sampler2D particle;
uniform sampler2D splat;
uniform sampler2D normal_depth;
uniform vec2 viewport;

in vec2 uv;
in vec2 uv2;
in vec3 wpos;
in float alpha;
in float tex_blend;
in float intensity;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_include.frag>

void main()
{
	const vec4 color = vec4(1.0); //vec4(1.0, 0.0, 0.0, 1.0);

	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = texture(normal_depth, uv_pos).w;
	vec3 pos = calc_position(uv_pos, d);

	if ( pos.z > wpos.z ) discard;

	float a = mix(texture(particle, uv).r*1.5, texture(splat, uv2).r, tex_blend) * alpha;
	frag_color.rgb = vec3(intensity*8.0) * a;
	frag_color.a = a;
}
