#version 330 core

uniform sampler2D particle;
uniform sampler2D normal_depth;
uniform vec2 viewport;
uniform float intensity;

in vec2 uv;
in vec3 wpos;
in float alpha;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_include.frag>

void main()
{
	const vec4 orange = vec4(1.0, 0.8, 0.6, 0.0);

	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = texture(normal_depth, uv_pos).w;
	vec3 pos = calc_position(uv_pos, d);

	if ( pos.z > wpos.z ) discard;

	float a = clamp((wpos.z - pos.z)*5.0, 0.0, 1.0) * alpha * intensity;

	frag_color = texture(particle, uv) * orange * a;
}
