#version 330 core

uniform sampler2D gradient;
uniform sampler2D diffuse;
uniform sampler2D specular;
uniform float extrude_time;
uniform float gradient_time;

in vec2 pos_zw;
in vec3 normal;
in vec2 uv;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;

void main()
{
	float grad = texture(gradient, uv.xy*0.1).x;
	if ( uv.y > extrude_time || grad < gradient_time ) discard;

	diffuse_specular.rgb = texture(diffuse, uv).rgb;
	diffuse_specular.a = texture(specular, uv).r;

	normal_depth.xyz = normalize(normal);
	normal_depth.w = pos_zw.x/pos_zw.y;
}
