package Ragedemo01;

import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import processing.core.*;


/**
 * RageDemo01: Uncle Cute - main class. Run this to get things rolling.
 * 
 * This is the afterparty release version, 
 * with the following adjustments made after the party version:
 * -Disabled hardcoded Instanssi 2011 party place light control system...
 * -...and added a switch for enabling it
 * -Added this boasting line stating that this demo won the Instanssi 2011 Demo Compo :)
 *
 * Unfortunately, the soundtrack sync seems to vary a little between runs, so there can't be
 * 100% accurate sound/visuals sync.
 *
 * @author Rage Manifesto
 * @version 002-2011.05.16
 *
 */
@SuppressWarnings("serial")
public class RageDemo01 extends PApplet {

    public static boolean IS_USING_LIGHTS = false;

    /*
     * This value is used for delaying the graphics transitions so that they would match with the soundtrack.
     * With slower computers it takes more time to get the soundtrack started.
     */
    public static int SOUNDTRACK_SYNC_SHIFTAMOUNT = 2200;  //the default value is 2200ms, as it was fine with my mediocre laptop
	
    
	//attributes for audio player
	Minim minim;
	AudioPlayer song;
	
	//effects
    RageGrass grass;
    RageFlorist florist1;
    RageFlowers singleFlower;
    RageBoxes boxLoop1;
    RageBoxes boxSplash1;
    
    
    private LightManager instanssi2011Lights;
    private int lmred = 0;
    private int lmgreen = 0;
    private int lmblue = 0;
    private int lightTrigger = 0;
    private int specialLightIndex = 32;
    
    private boolean isSoundtrackPlaying = false;
	private RageTexter text_rmpresents;
	private RageTexter text_ademocalled;
	private RageTexter text_unclecute;
	private RageUncle uncle1;
	private RageTexter text_loading;
	private RageTexter text_utilizingprocessing;
	private RageTexter text_framework;
	private RageTexter text_starring;
	private RageTexter text_unclecute2;
	private RageTexter text_vicmanual;
	private RageTexter text_youcantharm;
	private RageTexter text_bytyping;
	private RageTexter text_unlesselephant;
	private RageTexter text_letsseethat;
	private RageCheapStuff cheap1;
	private RageTexter text_haveahottip;
	private RageBowties bowtie1;
	private RageBowties bowtie2;
	private RageBowties bowtie3;
	private RageBowties bowtie4;
	private RageTexter text_bowties;
	private RageFlowers flowers1;
	private RageTexter text_treatgirls;
	private RageTexter text_havelotsofthem;
	private RageClouds cloud1;
	private RageTexter text_cutestuffedanimals;
	private RageTexter text_willsavetheworld;
	private RageCuteAnimal animal1;
	private RageCuteAnimal animal2;
	private RageCuteAnimal animal3;
	private RageCuteAnimal animal4;
	private RageClouds cloud2;
	private RageClouds cloud3;
	private RageClouds cloud4;
	private RageClouds cloud5;
	private RageClouds cloud6;
	private RageTexter text_boxclassic;
	private RageTexter text_itslikesaying;
	private RageHelloBox hellobox1;
	private RageHelloBox hellobox2;
	private RageHelloBox hellobox3;
	private RageHelloBox hellobox4;
	private RageBoxes boxes1;
	private RageBoxes boxes2;
	private RageTexter text_havelotsofthem2;
	private RageTexter text_makingdemos;
	private RageTexter text_somuchfun;
	private RageCuteAnimal animal5;
	private RageTexter text_code;
	private RageTexter text_music;
	private RageTexter text_abighand;
	private RageTexter text_somestaticgraphics;
	private RageTexter text_girlsfavourite;
	private RageTexter text_attheendofademo;
	private RageTexter text_haveanencore;
	private RageTexter text_partyhard;
	private RageCheapStuff cheap2;
	private RageFlowers flowers2;
	private RageCuteAnimal animal6;
	private RageTexter text_sources;
	private RageHelloBox hellobox5;
	private RageHelloBox hellobox6;
	private RageTexter text_sources2;
    
    
	
	
	
	public void setup(){
		size(1280, 720, P3D);
		frameRate(30);
		
		//keep the random seed 1337 through the whole demo, every effect is tweaked to
		//look fine with this value
		randomSeed(1337);
		

		System.out.println(SOUNDTRACK_SYNC_SHIFTAMOUNT);
		
		if ( IS_USING_LIGHTS ) {
		    
			//Instanssien valo-id:t: 32-45 (14kpl)
			this.instanssi2011Lights = new LightManager();
		}
		lmred = lmgreen = lmblue = 255;
		
		
		//initialization of all texts
		this.text_loading = new RageTexter(this, "LOADING :D", "Arial bold", 80, 400, 360, 0f, 0f, new int[]{222,222,222}, 255);
		this.text_rmpresents = new RageTexter(this, "Rage Manifesto\n presents", "Arial bold", 80, 500, 200, 0f, 0.5f, new int[]{222,222,222}, 255);
		this.text_ademocalled = new RageTexter(this, "a demo called", "Arial bold", 60, 550, 400, 0.5f, 0f, new int[]{222,222,222}, 255);
		this.text_unclecute = new RageTexter(this, "UNCLE CUTE", "Arial bold", 100, 550, 600, -0.075f, -0.4f, new int[]{255,150,150}, 255);
		this.text_utilizingprocessing = new RageTexter(this, "Utilizing\nProcessing 1.2.1", "Arial bold", 80, 400, 200, 0.5f, 0f, new int[]{125,125,255}, 255);
		this.text_framework = new RageTexter(this, "and\nRagely Nice Things\nFramework Mk01", "Arial bold", 80, 400, 400, -0.5f, 0f, new int[]{255,125,125}, 255);
		this.text_starring = new RageTexter(this, "starring", "Arial bold", 80, 500, 200, 0f, 1f, new int[]{255,125,125}, 255);
		this.text_unclecute2 = new RageTexter(this, "UNCLE CUTE", "Arial bold", 100, 550, 550, 0f, -0.5f, new int[]{255,150,150}, 255);
		this.text_girlsfavourite = new RageTexter(this, "the girls' favourite ;)", "Arial bold", 50, 550, 650, 0f, -0.25f, new int[]{255,5,5}, 255);
		this.text_vicmanual = new RageTexter(this, "As my VIC-20 manual says,", "Arial bold", 55, 400, 150, 0.5f, 0f, new int[]{244,244,244}, 255);
		this.text_youcantharm = new RageTexter(this, "''You can't harm\n a computer", "Arial bold", 80, 200, 150, 0.8f, 0f, new int[]{244,244,244}, 255);
		this.text_bytyping = new RageTexter(this, "by typing", "Arial bold", 80, 400, 375, -0.5f, 0f, new int[]{244,244,244}, 255);
		this.text_unlesselephant = new RageTexter(this, "unless you're\n an elephant.''", "Arial bold", 80, 350, 500, 0.5f, 0f, new int[]{244,244,244}, 255);
		this.text_letsseethat = new RageTexter(this, "We'll see that!! >:D", "Arial bold", 100, 200, 550, 0f, 0.25f, new int[]{255,12,12}, 255);
		this.text_haveahottip = new RageTexter(this, "Have a hot tip, son", "Arial bold", 70, 400, 150, 0f, 0.25f, new int[]{15,15,70}, 255);
		this.text_bowties = new RageTexter(this, "Your demo is a lot cuter\nwith some bow ties!", "Arial bold", 60, 300, 250, 0f, 0.25f, new int[]{50,5,5}, 255);
		this.text_treatgirls = new RageTexter(this, "Treat girls with flowers", "Arial bold", 55, 540, 620, 0f, 0f, new int[]{244,244,244}, 255);
		this.text_havelotsofthem = new RageTexter(this, "Have lots of them!", "Arial bold", 80, 200, 600, 0f, -0.25f, new int[]{5,5,5}, 255);
		this.text_cutestuffedanimals = new RageTexter(this, "Cute stuffed toys...", "Arial bold", 70, 400, 150, 0.25f, 0.25f, new int[]{244,244,244}, 255);
		this.text_willsavetheworld = new RageTexter(this, "Will save the World!", "Arial bold", 80, 300, 300, 0f, 0f, new int[]{15,5,5}, 255);
		this.text_boxclassic = new RageTexter(this, "A box is a\n timeless classic", "Arial bold", 80, 480, 80, 0f, 0.5f, new int[]{244,244,244}, 255);
		this.text_itslikesaying = new RageTexter(this, "It's like saying", "Arial bold", 80, 80, 100, 0f, 0f, new int[]{244,244,244}, 255);
		this.text_havelotsofthem2 = new RageTexter(this, "Have lots of them!!", "Arial bold", 80, 200, 600, 0.2f, -0.25f, new int[]{5,5,5}, 255);
		this.text_makingdemos = new RageTexter(this, "Making demos - ...", "Arial bold", 80, 450, 200, 0f, 0.5f, new int[]{245,245,245}, 255);
		this.text_somuchfun = new RageTexter(this, "So much fun!!", "Arial bold", 80, 200, 400, 0.5f, 0.8f, new int[]{180,5,5}, 255);
		this.text_code = new RageTexter(this, "code: Rage Manifesto", "Arial bold", 70, 400, 150, -0.5f, 0f, new int[]{5,5,5}, 255);
		this.text_music = new RageTexter(this, "music: King Thrill", "Arial bold", 70, 100, 250, 0.5f, 0f, new int[]{5,5,5}, 255);
		this.text_abighand = new RageTexter(this, "a big hand for jypa", "Arial bold", 70, 400, 350, -0.5f, 0f, new int[]{5,5,5}, 255);
		this.text_somestaticgraphics = new RageTexter(this, "some static graphics by Darkki", "Arial bold", 70, 100, 450, 0.5f, 0f, new int[]{5,5,5}, 255);
		this.text_attheendofademo = new RageTexter(this, "At the end of a demo..", "Arial bold", 80, 400, 200, 0.25f, 0.25f, new int[]{245,245,245}, 255);
		this.text_haveanencore = new RageTexter(this, "have an encore,\nand...", "Arial bold", 80, 500, 450, 0.5f, 0f, new int[]{245,245,245}, 255);
		this.text_partyhard = new RageTexter(this, "PARTY HARD!!!", "Arial bold", 100, 400, 300, 0f, 0f, new int[]{245,245,245}, 255);
		this.text_sources = new RageTexter(this, "Sources included\nin the release \\o/", "Arial bold", 80, 300, 300, 0f, 0f, new int[]{5,5,128}, 255);
		this.text_sources2 = new RageTexter(this, "Sources included\nin the release \\o/", "Arial bold", 80, 500, 100, 0f, 0f, new int[]{255,5,5}, 255);
		
		
		//initialization of effects
        this.grass = new RageGrass(this, 80);
        this.florist1 = new RageFlorist(this, 10);
        this.boxLoop1 = new RageBoxes(this, 100, -100.0f, true, false, true, 255, new int[]{255,255,255});
        this.boxSplash1 = new RageBoxes(this, 50, -10.0f, false, true, true, 255, new int[]{0,0,0});
        this.singleFlower = new RageFlowers(this, 800, 360, 0, 0, 0f, -0.06f, 20, 6, 12f, 1f, 0.5f, 255, 5, 25);
        this.uncle1 = new RageUncle(this);
        this.cheap1 = new RageCheapStuff(this, 1380f, 320f, -3.5f, 200f, 16);
        this.bowtie1 = new RageBowties(this, 200f, 150f, 1f, 1f);
        this.bowtie2 = new RageBowties(this, 600f, 320f, 0.25f, -0.25f);
        this.bowtie3 = new RageBowties(this, 650f, 340f, 0.125f, -0.125f);
        this.bowtie4 = new RageBowties(this, 850f, 450f, -1f, -0.5f);
        this.flowers1 = new RageFlowers(this, 900, 250, 0, 0, 0f, -0.1f, 16, 16, 1f, 27f, 0.3f, 255, 10, 50);
        this.cloud1 = new RageClouds(this, random(-100f, 1380f), random(0f, 100f), random(-2f, -0.3f), random(100f, 160f), (int)(random(5f, 12f)));
        this.animal1 = new RageCuteAnimal(this, "hippo.png", 100f, 350f, 3f, 0.8f);
        this.animal2 = new RageCuteAnimal(this, "patti.png", -200f, 320f, 2.5f, 1f);
        this.animal3 = new RageCuteAnimal(this, "mato.png", -350f, 320f, 2f, 1f);
        this.animal4 = new RageCuteAnimal(this, "poppo.png", -400f, 320f, 1.5f, 1.2f);
        this.cloud2 = new RageClouds(this, random(-100f, 1380f), random(0f, 200f), random(-2f, -0.3f), random(100f, 160f), (int)(random(5f, 12f)));
        this.cloud3 = new RageClouds(this, random(-100f, 1380f), random(0f, 200f), random(-2f, -0.3f), random(100f, 160f), (int)(random(5f, 12f)));
        this.cloud4 = new RageClouds(this, random(-100f, 1380f), random(0f, 200f), random(-2f, -0.3f), random(100f, 160f), (int)(random(5f, 12f)));
        this.cloud5 = new RageClouds(this, random(-100f, 1380f), random(0f, 200f), random(-2f, -0.3f), random(100f, 160f), (int)(random(5f, 12f)));
        this.cloud6 = new RageClouds(this, random(-100f, 1380f), random(0f, 200f), random(-2f, -0.3f), random(100f, 160f), (int)(random(5f, 12f)));
        this.hellobox1 = new RageHelloBox(this, "hello1tex.png", 650f, 290f, 1.0f);
        this.hellobox2 = new RageHelloBox(this, "hello2tex.png", 950f, 290f, -1.3f);
        this.hellobox3 = new RageHelloBox(this, "hello3tex.png", 650f, 520f, 0.8f);
        this.hellobox4 = new RageHelloBox(this, "hello4tex.png", 950f, 520f, -0.9f);
        this.boxes1 = new RageBoxes(this, 100, -10.0f, true, false, true, 255, new int[]{244,244,244});
        this.boxes2 = new RageBoxes(this, 300, -1000.0f, true, true, true, 255, new int[]{0,0,0});
        this.animal5 = new RageCuteAnimal(this, "leijona.png", -200f, 320f, 2.5f, 1f);
        this.cheap2 = new RageCheapStuff(this, 1380f, 320f, -3.5f, 200f, 16);
        this.flowers2 = new RageFlowers(this, 1000, 100, 0, 0, -10f, -0.1f, 16, 16, 1f, 27f, 0.3f, 255, 10, 50);
        this.animal6 = new RageCuteAnimal(this, "patti.png", 0f, 320f, 3f, 1.5f);
        this.hellobox5 = new RageHelloBox(this, "thxtex.png", 600f, 400f, -0.9f);
        this.hellobox6 = new RageHelloBox(this, "byetex.png", 850f, 480f, -0.9f);
		
				
		minim = new Minim(this);
		song = minim.loadFile("cute.mp3", 2048);
		song.cue(0);
	}
	
	public void draw(){
		
		if (millis() < 3000 ) { 
			//initialization of soundtrack
			if (isSoundtrackPlaying == false) {
				song.play();
				isSoundtrackPlaying = true;
			}
			background(22);
			text_loading.draw();
			
			if ( IS_USING_LIGHTS ) {
			    //System.out.println("valoja k�ytet��n");
				for ( int i = 32; i <= 45; i++ ) {
						instanssi2011Lights.setRGB(i, 0, 0, 0);
				}
			}
		
					

		}else if (millis() < 6136 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {

        	background(22);
        	uncle1.drawNormal();
        	text_rmpresents.draw();
        	text_ademocalled.draw();
        	text_unclecute.draw();
        	
        	
        	if ( lmred > 22 ) {
        		lmred--;
        		lmgreen--;
        		lmblue--;
        	}
        	
        	if ( IS_USING_LIGHTS ) {
        	    for ( int i = 32; i <= 45; i++ ) {
				    if ( lmred > 22 ) {
					    instanssi2011Lights.setRGB(i, lmred, lmgreen, lmblue);
				    }
        	    }
        	}
			
		}else if (millis() < 11633 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {

			lmred = (int) random(10f, 125f);
			lmgreen = (int) random(10f, 125f);
			lmblue = (int) random(10f, 125f);
			background(lmred, lmgreen, lmblue);
        	uncle1.drawNormal();
        	text_rmpresents.draw();
        	text_ademocalled.draw();
        	text_unclecute.draw();
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, lmred, lmgreen, lmblue);
				}
            }

        	
        	
        }else if (millis() < 17200 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {
        	background(12, 30, 30);
        	text_utilizingprocessing.draw();
        	text_framework.draw();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 12, 30, 30);
				}
            }
        	
        }else if (millis() < 21328 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {
        	background(30, 12, 30);
        	text_starring.draw();
        	text_unclecute2.draw();
        	text_girlsfavourite.draw();
        	uncle1.drawNormal();
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 30, 12, 30);
				}
            }
        	
        	
        	
        }else if (millis() < 22593 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {
        	
        	lmred = (int) random(10f, 255f);
			lmgreen = (int) random(10f, 255f);
			lmblue = (int) random(10f, 255f);
        	background(lmred, lmgreen, lmblue);
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, lmred, lmgreen, lmblue);
				}
            }
        	
        	
        }else if (millis() < 26417 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {
        	background(20,20,0);
        	text_vicmanual.draw();
        	uncle1.drawNormal();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 20, 20, 0);
				}
            }
        	
        	
        }else if (millis() < 33600 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {
        	background(20,20,0);
        	text_youcantharm.draw();
        	text_bytyping.draw();
        	text_unlesselephant.draw();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 20, 20, 0);
				}
            }
        	
        }else if (millis() < 44411 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {
        	background(20,0,20);
        	text_letsseethat.draw();
        	cheap1.draw();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 20, 0, 20);
				}
            }
        	

        }else if (millis() < 49926 + SOUNDTRACK_SYNC_SHIFTAMOUNT) { 
        	background(255, 165, 0);
        	text_haveahottip.draw();
        	uncle1.drawBowtie();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 255, 165, 0);
				}
            }
        	
        }else if (millis() < 55395 + SOUNDTRACK_SYNC_SHIFTAMOUNT) { 
        	background(255, 165, 0);
        	bowtie1.draw();
        	bowtie2.draw();
        	bowtie3.draw();
        	bowtie4.draw();
        	text_bowties.draw();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 255, 165, 0);
				}
            }
	
        }else if (millis() < 71739 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {  
        	background(20, 20, 20);
        	flowers1.draw();
        	text_treatgirls.draw();
        	uncle1.drawNormal();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 20, 20, 20);
				}
            }
        	
        }else if (millis() < 88219 + SOUNDTRACK_SYNC_SHIFTAMOUNT) { 
        	background(10, 180, 200);
        	florist1.draw();
        	cloud1.draw();
        	grass.draw();
        	text_havelotsofthem.draw();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 10, 180, 200);
				}
            }
        	
        }else if (millis() < 93625 + SOUNDTRACK_SYNC_SHIFTAMOUNT) { 
        	background(10, 10, 10);
        	text_cutestuffedanimals.draw();
        	uncle1.drawNormal();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 10, 10, 10);
				}
            }
        	
        }else if (millis() < 115579 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {  
        	background(10, 180, 200);
        	cloud1.draw();
        	cloud2.draw();
        	cloud3.draw();
        	cloud4.draw();
        	animal1.draw();
        	animal2.draw();
        	animal3.draw();
        	animal4.draw();
        	cloud5.draw();
        	cloud6.draw();
        	text_willsavetheworld.draw();
        	
        	lmred = lmgreen = lmblue = 255;
            if ( IS_USING_LIGHTS ) {
			    lightTrigger++;
            	if ( lightTrigger % 10 == 0 ) {
            		specialLightIndex++;
            		if ( specialLightIndex > 45 ) specialLightIndex = 32;

            	}
			    
				for ( int i = 32; i <= 45; i++ ) {
					if ( i == specialLightIndex ) continue;
					instanssi2011Lights.setRGB(i, 10, 180, 200);
				}
				instanssi2011Lights.setRGB(specialLightIndex, 255, 0, 0);
            }
        	
        }else if (millis() < 122000 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {
        	background(10, 10, 10);
        	text_boxclassic.draw();
        	uncle1.drawNormal();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					if ( lmred > 10 ) instanssi2011Lights.setRGB(i, lmred--, lmgreen--, lmblue--);
				}
            }
        	
        }else if (millis() < 126480 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {
        	background(10, 10, 10);
        	text_boxclassic.draw();
        	boxes1.draw();
        	uncle1.drawNormal();
        }else if (millis() < 137600 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {  
        	background(10, 10, 10);
        	text_itslikesaying.draw();
        	hellobox1.draw();
        	hellobox2.draw();
        	hellobox3.draw();
        	hellobox4.draw();
        }else if (millis() < 154000 + SOUNDTRACK_SYNC_SHIFTAMOUNT) { 
        	background(10, 180, 200);
        	boxes2.draw();
        	cloud1.draw();
        	cloud2.draw();
        	cloud3.draw();
        	cloud4.draw();
        	text_havelotsofthem2.draw();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 10, 180, 200);
				}
            }
        	
        }else if (millis() < 159400 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {
        	background(10, 10, 10);
        	boxes1.draw();
        	text_makingdemos.draw();
        	uncle1.drawNormal();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 10, 10, 10);
				}
            }
        	
        }else if (millis() < 164800 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {  
        	lmred = (int) random(10f, 125f);
			lmgreen = (int) random(10f, 125f);
			lmblue = (int) random(10f, 125f);
        	background(lmred, lmgreen, lmblue);
        	boxes1.draw();
        	animal5.draw();
        	text_somuchfun.draw();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, lmred, lmgreen, lmblue);
				}
            }
        	
        }else if (millis() < 170400 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {
        	background(245, 180, 245);
        	boxes2.draw();
        	cloud1.draw();
        	cloud2.draw();
        	cloud3.draw();
        	cloud4.draw();
        	cloud5.draw();
        	cloud6.draw();
        	text_code.draw();
        	text_music.draw();
        	text_abighand.draw();
        	text_somestaticgraphics.draw();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 245, 180, 245);
				}
            }
        	
        }else if (millis() < 181235 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {
        	background(5, 5, 5);
        	flowers2.draw();
        	cheap2.draw();
        	text_attheendofademo.draw();
        	text_haveanencore.draw();
        	uncle1.drawNormal();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 5, 5, 5);
				}
            }
        	
        }else if (millis() < 186707 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {
        	lmred = (int) random(10f, 125f);
			lmgreen = (int) random(10f, 125f);
			lmblue = (int) random(10f, 125f);
        	background(lmred, lmgreen, lmblue);
        	boxes2.draw();
        	animal6.draw();
        	text_partyhard.draw();
        	uncle1.drawParty();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, lmred, lmgreen, lmblue);
				}
            }
        	
        }else if (millis() < 197647 + SOUNDTRACK_SYNC_SHIFTAMOUNT) { 
        	lmred = (int) random(222f, 255f);
			lmgreen = (int) random(222f, 255f);
			lmblue = (int) random(222f, 255f);
        	background(lmred, lmgreen, lmblue);
        	bowtie1.draw();
        	bowtie2.draw();
        	bowtie3.draw();
        	bowtie4.draw();
        	text_sources.draw();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, lmred, lmgreen, lmblue);
				}
            }
        	
        }else if (millis() < 214000 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {  
        	background(5, 5, 5);
        	boxes1.draw();
        	text_sources2.draw();
        	hellobox5.draw();
        	uncle1.drawParty();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 5, 5, 5);
				}
            }
        	
        }else if (millis() < 220000 + SOUNDTRACK_SYNC_SHIFTAMOUNT) {  
        	background(5, 5, 5);
        	hellobox6.draw();
        	grass.draw();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
            	
            	lightTrigger++;
				for ( int i = 32; i <= 45; i++ ) {
					if ( lightTrigger % 2 == 0 ) instanssi2011Lights.setRGB(i, 255, 255, 255);
					else instanssi2011Lights.setRGB(i, 0, 0, 0);
				}
            }
        	
        }else {  
        	background(5, 5, 5);
        	hellobox6.draw();
        	grass.draw();
        	
        	
            if ( IS_USING_LIGHTS ) {
			    
				for ( int i = 32; i <= 45; i++ ) {
					instanssi2011Lights.setRGB(i, 0, 0, 0);
				}
            }
        }
		

	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		int shifter = 0;
		
		if ( args.length > 0 && args[0] != null ) {

			    try {
			    	shifter = Integer.parseInt(args[0]);
			    	System.out.println("shiftAmount: " + shifter + "ms");
			    } catch (NumberFormatException e) {
			    		System.out.println("shiftAmount argument was not a valid integer - using the default value: " + shifter + "ms");
			    }
			RageDemo01.SOUNDTRACK_SYNC_SHIFTAMOUNT = RageDemo01.SOUNDTRACK_SYNC_SHIFTAMOUNT + -(shifter);
			} else {
				System.out.println("shiftAmount argument was not given - using the default value: " + shifter + "ms");
			}
		
			
			if ( args.length > 1 && args[1] != null ) {
				if ( args[1].contains("lights") ) {
					System.out.println("Lights enabled");
					RageDemo01.IS_USING_LIGHTS = true;
				}			
			}

		PApplet.main(new String[] { "--present", "Ragedemo01.RageDemo01" });
	}

}
