varying vec3 normal;
varying vec3 lightvec;
varying vec4 distancia;

uniform vec3 color;

vec3 ambient = vec3(0.3, 0.3, 0.3);
uniform sampler2D tex0;
uniform float time;

void main()
{
	
	vec3 diffuse= vec3(0.0,0.0,0.0);
	vec4 col;
	vec2 offs;
	float dis;
	float angle;


	vec3 nnormal = normalize(normal);
	vec3 nlightvec = normalize(lightvec);

	
	angle = max(dot(nlightvec, nnormal), 0.0);
	diffuse = ( color  * angle);
	
	dis = length(distancia)*0.2;	
	dis = 1.0 / (0.00001+ 0.01 * dis + 0.05 * dis * dis);
	
	
	col  = vec4( (diffuse +ambient)*dis * 0.5, 1.0);
	
	
	offs = (gl_FragCoord/vec2(2560.0, 1600.0)) + vec2(time,0.0);
	
	col *= vec4(texture2D(tex0, offs).xyz,1.0)*0.6;
	
	gl_FragColor = col; 
}


