uniform sampler2D tex0;

varying vec2 offs;

uniform float time;

uniform vec2 resolution;

void main()
{
	vec2 of;
	vec3 col;

	vec2 q = vec2(1.0/resolution.x, 1.0/resolution.y)*time;
	
	of = offs;
	of.x += sin(of.y+time*4.0)*(time / 34.0);
	col.r = texture2D(tex0, vec2(of.x+q.x, of.y)).r;
	col.g = texture2D(tex0, vec2(of.x-q.x, of.y)).g;
	col.b = texture2D(tex0, vec2(of.x    , of.y+q.y)).b;
	
	gl_FragColor = vec4(col,1.0);
}


