
float4 compAcc(float4 p, float4 g){
	float4 gp;
	gp.x = g.x-p.x;
	gp.y = g.y-p.y;
	gp.z = g.z-p.z;
	float d = gp.x*gp.x + gp.y*gp.y + gp.z*gp.z + 1.0f;
	d = rsqrt(d);
	d = d*d*d;
	gp *= g.w*d;
	return gp;
}

__kernel void flowparticles(__global float4* pos, __global float4* acc, float time, float acctime)
{
	time *= 2; acctime *= 2;
	unsigned int p = get_global_id(0);
	unsigned int sz = get_global_size(0);
	unsigned int l = get_local_id(0);
	float4 pp = pos[p];
	float4 sum = (float4)(0,0,0,0);
	
	float4 grav = (float4)(sin(acctime*0.23f)*5.0,cos(acctime*0.17f)*9.0,sin(acctime*0.12f)*1.7 + cos(acctime*0.22f)*5.1,3.0);
	float4 grav2 = (float4)(sin(acctime*0.12f)*4.7 + cos(acctime*0.22f)*2.1,sin(acctime*0.19f)*3.7,cos(acctime*0.15f)*9.0,3.0);
	float4 grav3 = (float4)(sin(acctime*0.21f)*6.7,cos(acctime*0.13f)*5.0,sin(acctime*0.23f)*5.7 + cos(acctime*0.14f)*1.1,3.0);

	sum += compAcc(pp, grav)+compAcc(pp, grav2) + compAcc(pp, grav3);
	
	sum *= (float4)(1.0,1.0,1.0,0.0);
	float4 a = acc[p] + sum*time;
	pp += a*time;
	a *= 0.996;
	acc[p] = a;
	pos[p] = pp;
}