#version 150
layout(points) in;
layout(points, max_vertices = 10) out;

in vec4 geopos[];
in vec4 opos[];
out vec4 pos;
out vec4 gpos;
uniform float distort;
uniform mat4 mat;
float sig(float t){return 1.f/(1.f+pow(2.71828f,-t)); }

void main() {
	gl_Position = geopos[0];
	pos = opos[0];
	gpos = geopos[0];
	gl_PointSize = min(max(1.0f, (100-geopos[0].z*0.01)*0.075f),64.0f);
	gl_Position.y += -(cos(((gl_Position.x+gl_Position.z)/gl_Position.w)*3.14159*0.5-3.14159/2)+1)*4000.f*(sig(distort*0.2)-0.5)+2000;
	EmitVertex();
	EndPrimitive();
}
