float noise(vec2 pos,int seed);
float cosInterpolate(vec2 a, float x);
float smooth_2d_noise(vec2 pos,int seed);

float noise(vec2 pos,int seed) {
	float ret = fract(sin(seed+dot(pos,vec2(12.9898,78.233)))*43758.5453)*2.0-0.8;
	return ret;
}

float smooth_2d_noise(vec2 pos,int seed) {
	vec3 a = vec3(0,0,0);
	float ret;
	a.x = (noise(vec2(pos.x-1,pos.y-1),seed) + noise(vec2(pos.x+1,pos.y-1),seed) + noise(vec2(pos.x-1,pos.y+1),seed) + noise(vec2(pos.x+1,pos.y+1),seed)) / 16;
	a.y = (noise(vec2(pos.x-1,pos.y),seed) + noise(vec2(pos.x+1,pos.y),seed) + noise(vec2(pos.x,pos.y-1),seed) + noise(vec2(pos.x,pos.y+1),seed) ) / 8;
	a.z = noise(pos,seed)/4;
	ret = a.x + a.y + a.z;
	return ret;
}

float cosInterpolate(vec2 a, float x) {
	float ft,f,ret;
	float PI = 3.14159265358979323846264;
	ft = (x*PI);
	f = ((1-cos(ft)) * 0.5);
	ret = a.x*(1-f)+a.y*f;
	return ret;
}


float cos_2d_noise(vec2 pos, int seed) {
	vec2 int_pos = floor(pos);
	vec2 frac_pos = pos - int_pos;//fract(pos);
	float ret;
	vec4 v;
	vec2 i;
	
	v.x = smooth_2d_noise(int_pos,seed);	
	v.y = smooth_2d_noise(vec2(int_pos.x+1.0,int_pos.y),seed);
	v.z = smooth_2d_noise(vec2(int_pos.x,int_pos.y+1),seed);
	v.a = smooth_2d_noise(vec2(int_pos.x+1.0,int_pos.y+1.0),seed);
	
	i.x = cosInterpolate(vec2(v.x,v.y),frac_pos.x);
	i.y = cosInterpolate(vec2(v.z,v.a),frac_pos.x);
	
	ret = cosInterpolate(i,frac_pos.y);
	
	return ret;
}


float perlinNoise(vec2 pos,int seed,float timer) {
	int i;
	float ret = 0.0;
	float freq,amp;
	int p = 10;
	int n = 3;
	
	for(i=0;i<n;i++) {
		freq = pow(2,i);
		amp = pow(p,i);
		ret += cos_2d_noise(vec2(pos.x*freq,pos.y*freq),seed) *amp;
		ret += 0.1;
	}
	
	return ret;
}




uniform float timer;
varying vec3 position;
void main() {
	//gl_FragColor = vec4(1,sin(timer*gl_TexCoord[0].s),0,1);
	//gl_FragColor = vec4(0,0,0,1);


	//gl_FragColor.x = 1-(perlinNoise(gl_TexCoord[0].st*20+vec2(timer*0.2,0),10,timer)*0.5);
	//gl_FragColor.yz = vec2(gl_FragColor.x,gl_FragColor.x);

	//gl_FragColor.xyz *= cos(position.y*0.009);

	gl_FragColor.a = 1.0;
	gl_FragColor.z = 0.2*(1-cos((position.y-50)*0.002));

}
