package org.shiftone.jrat.provider.tree.ui.children;

import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.util.Percent;
import org.shiftone.jrat.util.time.TimeUnit;
import org.shiftone.jrat.util.log.Logger;
import org.shiftone.jrat.provider.tree.ui.StackTreeNode;
import javax.swing.table.AbstractTableModel;
import java.util.ArrayList;
import java.util.List;

/**
 * @author $Author: jeffdrost $
 * @version $Revision: 1.3 $
 */
public class ChildrenTableModel extends AbstractTableModel {

	private static final Logger LOG = Logger.getLogger(ChildrenTableModel.class);
	private List children = new ArrayList();
	private long parentTotalDurationNanos;
	private Percent parentTotalDurationPercent;
	private String[] COLUMN_NAMES = { "Class", "Method", "Signature", //
			"Enters", "Exits", "Errors", //
			"Threads", "Total ms", //
			"Avg ms", "Std Dev", //
			"Min ms", "Max ms", //
			"%Node", };
	private Class[] COLUMN_TYPES = { String.class, String.class, String.class, //
			Long.class, Long.class, Long.class, //
			Integer.class, Long.class, //
			Float.class, Double.class, //
			Long.class, Long.class, //
			Percent.class, };

	public synchronized void setStackTreeNode(StackTreeNode node) {

		List newChildren = new ArrayList();
		newChildren.add(node);
		int childrenTotalDurationNanos = 0;
		for (int i = 0; i < node.getChildCount(); i++) {
			StackTreeNode child = (StackTreeNode) node.getChildAt(i);
			childrenTotalDurationNanos += child.getTotalDurationNanos();
			newChildren.add(child);
		}
		children = newChildren;
		if (node.getTotalDurationNanos() == 0) {
			parentTotalDurationPercent = null;
		} else {
			parentTotalDurationNanos = node.getTotalDurationNanos() - childrenTotalDurationNanos;
			parentTotalDurationPercent = new Percent(parentTotalDurationNanos * 100.0 / node.getTotalDurationNanos());
		}
		fireTableDataChanged();
	}

	public int getRowCount() {

		return children.size();
	}

	public int getColumnCount() {

		return COLUMN_NAMES.length;
	}

	public String getColumnName(int columnIndex) {

		return COLUMN_NAMES[columnIndex];
	}

	public Class getColumnClass(int columnIndex) {

		return COLUMN_TYPES[columnIndex];
	}

	public boolean isCellEditable(int rowIndex, int columnIndex) {

		return false;
	}

	public Object getValueAt(int rowIndex, int columnIndex) {

		StackTreeNode node = (StackTreeNode) children.get(rowIndex);
		MethodKey methodKey = node.getMethodKey();
		if (methodKey == null) {
			return "?";
		}
		switch (columnIndex) {
		case 0:
			return methodKey.getClassName();
		case 1:
			return methodKey.getMethodName();
		case 2:
			return methodKey.getPrettySignature();
		case 3:
			return new Long(node.getTotalEnters());
		case 4:
			return new Long(node.getTotalExits());
		case 5:
			return new Long(node.getTotalErrors());
		case 6:
			return new Integer(node.getMaxConcurrentThreads());
		case 7:
			return new Long(node.getTotalDuration(TimeUnit.MS));
		case 8:
			return node.getAverageDuration(TimeUnit.MS);
		case 9:
			return node.getStdDeviation();
		case 10:
			return node.getMinDuration(TimeUnit.MS);
		case 11:
			return node.getMaxDuration(TimeUnit.MS);
		case 12:
			return (rowIndex == 0) ? parentTotalDurationPercent : new Percent(node.getPctOfAvgParentDuration());
		}
		return null;
	}
}
