package org.shiftone.jrat.core;

import org.shiftone.jrat.core.shutdown.ShutdownListener;
import org.shiftone.jrat.core.shutdown.ShutdownRegistry;
import org.shiftone.jrat.core.spi.RuntimeContext;
import org.shiftone.jrat.core.output.OutputDirectory;
import org.shiftone.jrat.ui.viewer.SimpleTextOutputViewBuilder;
import org.shiftone.jrat.util.AtomicLong;
import org.shiftone.jrat.util.VersionUtil;
import org.shiftone.jrat.core.jmx.JmxRegistry;
import org.shiftone.jrat.util.log.Logger;
import org.shiftone.jrat.util.log.LoggerFactory;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

/**
 * Class RuntimeContextImpl
 * 
 * @author $Author: jeffdrost $
 * @version $Revision: 1.61 $
 */
class RuntimeContextImpl implements RuntimeContext {

	protected static final Logger LOG = Logger.getLogger(RuntimeContextImpl.class);
	private final AtomicLong sequence = new AtomicLong();
	private final long startTimeMs = System.currentTimeMillis();
	private final ShutdownRegistry shutdownRegistry;
	private final JmxRegistry jmxRegistry;
	private final OutputDirectory outputDirectory;

	RuntimeContextImpl() {

		LOG.debug("new RuntimeContextImpl");
		ServiceFactory serviceFactory = ServiceFactory.getInstance();
		outputDirectory = OutputDirectory.create(serviceFactory.getFileOutputFactory());
		shutdownRegistry = serviceFactory.getShutdownRegistry();
		jmxRegistry = serviceFactory.getJmxRegistry();
		redirectLogStream();
	}

	public long getStartTimeMs() {

		return startTimeMs;
	}

	public void registerMBean(Object mbean) {

		registerMBean(mbean, null);
	}

	public void registerMBean(Object mbean, String objectNameText) {

		jmxRegistry.registerMBean(mbean, objectNameText);
	}

	private void redirectLogStream() {

		PrintWriter printWriter;
		try {
			printWriter = outputDirectory.createPrintWriter("JRat-LOG.jrat");
			printWriter.print("viewer=\"");
			printWriter.print(SimpleTextOutputViewBuilder.class.getName());
			printWriter.println("\"");
			LoggerFactory.redirectLogging(printWriter);
			LOG.info("logfile created");
			LOG.info("Running JRat version " + VersionUtil.getVersion() + " - built on " + VersionUtil.getBuiltOn());
		} catch (Exception e) {
			LOG.warn("unable to redirect LOG to file", e);
		}
	}

	public PrintWriter createPrintWriter(String fileName) {

		return outputDirectory.createPrintWriter(fileName);
	}

	public OutputStream createOutputStream(String fileName) {

		return outputDirectory.createOutputStream(fileName);
	}

	public Writer createWriter(String fileName) {

		return outputDirectory.createWriter(fileName);
	}

	public synchronized long uniqNumber() {

		return sequence.incrementAndGet();
	}

	public void registerShutdownListener(ShutdownListener listener) {

		shutdownRegistry.registerShutdownListener(listener);
	}

	public String toString() {

		return "RuntimeContextImpl created @ " + startTimeMs;
	}
}
