package org.shiftone.jrat.aop.cglib;

import net.sf.cglib.proxy.MethodProxy;
import org.shiftone.jrat.api.Command;

/**
 * @author $Author: jeffdrost $
 * @version $Revision: 1.5 $
 */
public class CglibMethodInvocationCommand implements Command {

	private final Object target;
	private final Object[] args;
	private final MethodProxy methodProxy;

	public CglibMethodInvocationCommand(MethodProxy methodProxy, Object target, Object[] args) {

		this.target = target;
		this.methodProxy = methodProxy;
		this.args = args;
	}

	public Object execute() throws Throwable {

		return methodProxy.invoke(target, args);
	}
}
