/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jogg;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import org.sourceforge.jogg.JOgg;

public class JOggProperties
extends Properties {
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String OGG_EXECUTABLE = "jogg.ogg_executable";
    public static final String OGG_BITRATE = "jogg.ogg_bitrate";
    public static final String OUTPUT = "jogg.outputdir";
    public static final String WAVDIR = "jogg.wavdir";
    public static final String OGG_QUALITY = "jogg.ogg_quality";
    public static final String OGG_EXTENSION = "jogg.ogg_extension";
    public static final String DISCID = "jogg.discid";
    public static final String CDDB_LOCAL = "jogg.cddb_local";
    public static final String ENCODER_METHOD = "jogg.encoder_method";
    public static final String MP3_EXECUTABLE = "jogg.mp3_executable";
    public static final String MP3_EXTENSION = "jogg.mp3_extension";
    public static final String MP3_BITRATE = "jogg.mp3_bitrate";
    public static final String OGG = "Ogg";
    public static final String MP3 = "MP3";
    public static final String[] ENCODER_METHODS = new String[]{"Ogg", "MP3"};
    public static final String PROPFILE = String.valueOf(USER_HOME) + File.separator + "jogg.properties";
    public static final String[] KEYS = new String[]{"jogg.ogg_executable", "jogg.ogg_bitrate", "jogg.outputdir", "jogg.wavdir", "jogg.ogg_quality", "jogg.ogg_extension", "jogg.discid", "jogg.cddb_local", "jogg.encoder_method", "jogg.mp3_executable", "jogg.mp3_extension", "jogg.mp3_bitrate"};
    private File _propertyFile;
    private static JOggProperties _props;
    private boolean _hasPropFile = false;

    private JOggProperties() throws IOException {
        this(new File(PROPFILE));
    }

    private JOggProperties(File propertyFile) throws IOException {
        this.setPropertyFile(propertyFile);
        this.load();
    }

    public static JOggProperties getInstance() {
        try {
            if (_props == null) {
                _props = new JOggProperties();
            }
        }
        catch (IOException e) {
            RuntimeException x = new RuntimeException("Cannot instantiate JOggProperties");
            x.initCause(e);
            throw x;
        }
        return _props;
    }

    public String getMP3Executable() {
        return this.getProperty(MP3_EXECUTABLE, "mp3encode");
    }

    public void setMP3Executable(String exe) {
        this.setString(MP3_EXECUTABLE, exe, "mp3encode");
    }

    public String getMP3Extension() {
        return this.getProperty(MP3_EXTENSION, ".mp3");
    }

    public void setMP3Extension(String ext) {
        this.setString(MP3_EXTENSION, ext, ".mp3");
    }

    public String getEncoderMethod() {
        return this.getProperty(ENCODER_METHOD, OGG);
    }

    public boolean isOggEncoding() {
        return this.getEncoderMethod().equals(OGG);
    }

    public boolean isMP3Encoding() {
        return this.getEncoderMethod().equals(MP3);
    }

    public void setEncoderMethod(String method) {
        this.setString(ENCODER_METHOD, method, OGG);
    }

    public String getLocalCDDB() {
        return this.getProperty(CDDB_LOCAL, ".");
    }

    public void setLocalCDDB(String cddb) {
        this.setString(CDDB_LOCAL, cddb, ".");
    }

    public int getOggBitrate() {
        String bitRate = this.getProperty(OGG_BITRATE, "256");
        int rate = Integer.parseInt(bitRate);
        this.setOggBitrate(rate);
        return rate;
    }

    public void setOggBitrate(int bitRate) {
        this.setProperty(OGG_BITRATE, "" + bitRate);
    }

    public int getMP3Bitrate() {
        String bitRate = this.getProperty(MP3_BITRATE, "256");
        int rate = Integer.parseInt(bitRate);
        this.setMP3Bitrate(rate);
        return rate;
    }

    public void setMP3Bitrate(int bitRate) {
        this.setProperty(MP3_BITRATE, "" + bitRate);
    }

    public int getOggQuality() {
        int quality = Integer.parseInt(this.getProperty(OGG_QUALITY, "3"));
        this.setOggQuality(quality);
        return quality;
    }

    public void setOggQuality(int quality) {
        this.setProperty(OGG_QUALITY, "" + quality);
    }

    public String getOutputDir() {
        return this.getProperty(OUTPUT, ".");
    }

    public void setOutputDir(String output) {
        this.setString(OUTPUT, output, ".");
    }

    public String getWavDir() {
        return this.getProperty(WAVDIR, ".");
    }

    public void setWavDir(String wavdir) {
        this.setString(WAVDIR, wavdir, ".");
    }

    public String getOggExecutable() {
        return this.getProperty(OGG_EXECUTABLE, "oggenc");
    }

    public void setOggExecutable(String executable) {
        this.setString(OGG_EXECUTABLE, executable, "oggenc");
    }

    public String getOggExtension() {
        return this.getProperty(OGG_EXTENSION, ".ogg");
    }

    public void setOggExtension(String extension) {
        this.setString(OGG_EXTENSION, extension, ".ogg");
    }

    public String getDiscId() {
        return this.getProperty(DISCID, "discid");
    }

    public void setDiscId(String discId) {
        this.setString(DISCID, discId, "discid");
    }

    private void setDefaults() {
        this.setDiscId(this.getDiscId());
        this.setEncoderMethod(this.getEncoderMethod());
        this.setLocalCDDB(this.getLocalCDDB());
        this.setMP3Executable(this.getMP3Executable());
        this.setMP3Extension(this.getMP3Extension());
        this.setMP3Bitrate(this.getMP3Bitrate());
        this.setOggBitrate(this.getOggBitrate());
        this.setOggExecutable(this.getOggExecutable());
        this.setOggExtension(this.getOggExtension());
        this.setOggQuality(this.getOggQuality());
        this.setOutputDir(this.getOutputDir());
        this.setPropertyFile(this.getPropertyFile());
        this.setWavDir(this.getWavDir());
    }

    private void setString(String key, String value, String dflt) {
        if (value != null) {
            this.setProperty(key, value);
        } else {
            this.setProperty(key, dflt);
        }
    }

    public void load() throws IOException {
        this.load(this.getPropertyFile());
    }

    public void load(File propertyFile) throws IOException {
        if (!propertyFile.exists()) {
            this.setHasPropFile(false);
            propertyFile.createNewFile();
        } else {
            this.setHasPropFile(true);
        }
        this.load(new FileInputStream(propertyFile));
        if (((Hashtable)this).size() == 0) {
            this.setDefaults();
        }
    }

    public void save() throws IOException {
        this.save(this.getPropertyFile());
    }

    public void save(File propertyFile) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(propertyFile, false));
        String properties = this.getProperties();
        writer.write(properties);
        writer.flush();
        writer.close();
    }

    public String getProperties() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < KEYS.length) {
            buf.append(String.valueOf(KEYS[i]) + "=" + this.getProperty(KEYS[i]));
            if (i != KEYS.length - 1) {
                buf.append(JOgg.NEW_LINE);
            }
            ++i;
        }
        return buf.toString();
    }

    public File getPropertyFile() {
        return this._propertyFile;
    }

    public void setPropertyFile(File file) {
        this._propertyFile = file;
    }

    public boolean hasPropFile() {
        return this._hasPropFile;
    }

    private void setHasPropFile(boolean b) {
        this._hasPropFile = b;
    }
}

