/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jogg;

import com.antelmann.cddb.CDDB;
import com.antelmann.cddb.CDDBEntry;
import com.antelmann.cddb.CDDBRecord;
import com.antelmann.cddb.CDDrive;
import com.antelmann.cddb.CDDriveWin;
import com.antelmann.cddb.CDID;
import com.antelmann.cddb.CDInfo;
import com.antelmann.cddb.Contribution;
import com.antelmann.cddb.FileCDDB;
import com.antelmann.cddb.FreeDB;
import com.antelmann.cddb.Track;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Set;
import org.sourceforge.jogg.JOgg;
import org.sourceforge.jogg.JOggProperties;
import org.sourceforge.jogg.SongData;
import org.sourceforge.jogg.exception.CDDBMismatchException;

public class JOggCDDB {
    private CDID _cdid;
    private JOggProperties _properties = JOggProperties.getInstance();
    private FreeDB _db;
    private FileCDDB _localDb;
    private CDInfo _info;

    public JOggCDDB() {
        try {
            this.init();
        }
        catch (Exception e) {
            RuntimeException boom = new RuntimeException("Unable to instantiate JOggCDDB");
            boom.initCause(e);
            throw boom;
        }
    }

    public void setInfo(SongData[] data) throws IOException, ParseException, CDDBMismatchException, InterruptedException {
        CDDBEntry entry = this.getEntry();
        Track[] tracks = this.getTrackInfo(entry, data);
        this.setInfo(data, tracks, entry);
        this.saveLocalRecord(entry);
    }

    public SongData[] getData() throws IOException, ParseException, CDDBMismatchException, InterruptedException {
        CDDBEntry entry = this.getEntry();
        Track[] tracks = entry.extractTracks(true);
        SongData[] data = this.createBlankData(tracks.length);
        this.setInfo(data, tracks, entry);
        this.saveLocalRecord(entry);
        return data;
    }

    public boolean isInLocalDatabase() throws IOException {
        return this._localDb.isInDatabase(this._cdid);
    }

    public void init() throws IOException, InterruptedException {
        this._db = new FreeDB();
        this._cdid = this.getOSCDID();
        this._localDb = new FileCDDB(new File(this._properties.getLocalCDDB()));
    }

    private void saveLocalRecord(CDDBEntry entry) throws IOException {
        if (!this._localDb.isInDatabase(this._cdid)) {
            this._localDb.writeCDInfo(this._info);
        }
    }

    private SongData[] createBlankData(int size) {
        SongData[] data = new SongData[size];
        int i = 0;
        while (i < data.length) {
            data[i] = new SongData();
            ++i;
        }
        return data;
    }

    private void setInfo(SongData[] data, Track[] tracks, CDDBEntry entry) throws CDDBMismatchException {
        int i = 0;
        while (i < tracks.length) {
            data[i].setAlbum(entry.getCDDBRecord().getTitle());
            data[i].setArtist(entry.extractTrackArtist(i).getName());
            data[i].setSongTitle(tracks[i].getTitle());
            data[i].setGenre(entry.getCDDBRecord().getCategory());
            data[i].setTrackNum(tracks[i].getTrackNo());
            data[i].setComments(this.getComments(tracks[i].getAllContributions()));
            ++i;
        }
    }

    private CDDBEntry getEntry() throws IOException, InterruptedException, ParseException {
        CDDBEntry entry = this.getEntry((CDDB)this._localDb);
        if (entry == null && (entry = this.getEntry((CDDB)this._db)) == null) {
            throw new NullPointerException("Could not find cd entry");
        }
        return entry;
    }

    private CDDBEntry getEntry(CDDB db) throws IOException, InterruptedException, ParseException {
        CDDBRecord record = this.getClosestMatch(db);
        if (record == null) {
            return null;
        }
        this._info = db.readCDInfo(record);
        CDDBEntry entry = new CDDBEntry(record, this._info.getXmcdContent());
        return entry;
    }

    private String getComments(Set allContributions) {
        StringBuffer comments = new StringBuffer("");
        if (!allContributions.isEmpty()) {
            Iterator it = allContributions.iterator();
            while (it.hasNext()) {
                Contribution contribution = (Contribution)it.next();
                comments.append(contribution.getComment());
                comments.append(JOgg.NEW_LINE);
            }
        }
        return comments.toString();
    }

    private Track[] getTrackInfo(CDDBEntry entry, SongData[] data) throws CDDBMismatchException {
        Track[] tracks = entry.extractTracks(true);
        if (tracks.length != data.length) {
            throw new CDDBMismatchException(data, tracks, "Wrong info from freedb");
        }
        return tracks;
    }

    private CDDBRecord getClosestMatch(CDDB db) throws IOException, InterruptedException {
        CDDBRecord[] records = db.queryCD(this._cdid);
        CDDBRecord record = null;
        int i = 0;
        while (i < records.length) {
            if (records[i].isExactMatch()) {
                record = records[i];
                break;
            }
            ++i;
        }
        if (record == null && records.length > 0) {
            record = records[0];
        }
        return record;
    }

    private String getCDInfoString() throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(this.getCommandArray());
        int result = p.waitFor();
        BufferedInputStream in = new BufferedInputStream(p.getInputStream());
        int avail = in.available();
        byte[] b = new byte[avail];
        in.read(b);
        String s = new String(b).trim();
        return s;
    }

    private String[] getCommandArray() {
        String[] s = new String[]{this._properties.getDiscId()};
        return s;
    }

    private CDID getOSCDID() throws InterruptedException, IOException {
        CDID cdid = JOgg.isWindows() ? new CDID((CDDrive)new CDDriveWin()) : new CDID(this.getCDInfoString());
        return cdid;
    }
}

