/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jogg;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.filechooser.FileFilter;
import org.sourceforge.jogg.AboutWindow;
import org.sourceforge.jogg.DataPanel;
import org.sourceforge.jogg.EncoderWindow;
import org.sourceforge.jogg.JOggCDDB;
import org.sourceforge.jogg.JOggProperties;
import org.sourceforge.jogg.MenuBar;
import org.sourceforge.jogg.OptionsWindow;
import org.sourceforge.jogg.SongData;
import org.sourceforge.jogg.WavFilter;
import org.sourceforge.jogg.exception.CDDBMismatchException;
import org.sourceforge.jogg.layout.GBLayout;

public class JOgg
implements ActionListener {
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final String OS = System.getProperty("os.name");
    private JFrame _frame = new JFrame("JOgg Encoder");
    private DataPanel _data = new DataPanel();
    private JButton _encode = new JButton("Encode");
    private JButton _propertyButton = new JButton("Options");
    private JButton _freeDB = new JButton("CDDB lookup");
    private MenuBar _menu = new MenuBar();
    private JButton _refresh = new JButton("Refresh");
    private JOggProperties _properties;
    private JOggCDDB _cddb;

    public JOgg() throws CDDBMismatchException, InterruptedException, IOException, ParseException {
        this.init();
        this._frame.pack();
        GBLayout.centerOnScreen(this._frame);
        this._frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JOgg.this.exit();
            }
        });
    }

    public static void main(String[] args) {
        try {
            JOgg jogg = new JOgg();
            jogg.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isWindows() {
        return OS.indexOf("Windows") >= 0;
    }

    public static boolean isLinux() {
        return OS.indexOf("Linux") >= 0;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.isAction(e, this._encode)) {
            if (this.isReady()) {
                this.encodeFiles();
            }
        } else if (this.isAction(e, this._propertyButton)) {
            try {
                this.showPropertyEditor();
            }
            catch (Exception f) {
                this.showException(f);
            }
        } else if (this.isAction(e, this._freeDB)) {
            this.getFreeDBInfo();
        } else if (this.isAction(e, this._refresh)) {
            try {
                this.refresh();
            }
            catch (Exception f) {
                this.showException(f);
            }
        } else if (e.getActionCommand().equals("Exit")) {
            this.exit();
        } else if (e.getActionCommand().equals("About")) {
            this.showAbout();
        }
    }

    public void show() {
        this._frame.show();
        if (!this._properties.hasPropFile()) {
            try {
                this.showPropertyEditor();
            }
            catch (Exception e) {
                this.showException(e);
            }
        }
    }

    private void showAbout() {
        AboutWindow.showAbout(this._frame);
    }

    private void exit() {
        this.saveProperties();
        System.exit(0);
    }

    private boolean isAction(ActionEvent e, JButton b) {
        return e.getActionCommand().equals(b.getActionCommand());
    }

    private void getFreeDBInfo() {
        try {
            SongData[] rows = this._data.getAllRows();
            this._cddb.setInfo(rows);
            this._data.setAllRows(rows);
        }
        catch (Exception e) {
            this.showException(e);
        }
    }

    private void showException(Exception e) {
        e.printStackTrace();
        JOptionPane.showMessageDialog(this._frame, e.getMessage(), e.getClass().getName(), 0);
    }

    private void showPropertyEditor() throws CDDBMismatchException, InterruptedException, IOException, ParseException {
        OptionsWindow options = new OptionsWindow(this._frame);
        options.show();
        this.refresh();
    }

    private void refresh() throws CDDBMismatchException, InterruptedException, IOException, ParseException {
        this._cddb.init();
        this.populateTextArea(this.getWavFiles(this._properties.getWavDir()));
    }

    private void encodeFiles() {
        File output = new File(this._properties.getOutputDir());
        String wavDir = this._properties.getWavDir();
        EncoderWindow enc = new EncoderWindow(this._frame, output, wavDir, this._data.getSelectedRows());
        enc.show();
    }

    private boolean isReady() {
        return this.isWavDirReady() && this.isOutputDirReady() && this.isWavFilesReady();
    }

    private boolean isWavFilesReady() {
        boolean isReady;
        boolean bl = isReady = this._data.getRowCount() > 0;
        if (!isReady) {
            this.showWavDirError();
        } else {
            boolean bl2 = isReady = this._data.getSelectedRowCount() > 0;
            if (!isReady) {
                JOptionPane.showMessageDialog(this._frame, "You must select at least one track");
            }
        }
        return isReady;
    }

    private void showWavDirError() {
        JOptionPane.showMessageDialog(this._frame, "You must select a .wav file directory");
    }

    private boolean isWavDirReady() {
        boolean isReady = this.isTextReady(this._properties.getWavDir());
        if (!isReady) {
            this.showWavDirError();
        }
        return isReady;
    }

    private boolean isOutputDirReady() {
        boolean isReady = this.isTextReady(this._properties.getOutputDir());
        if (isReady) {
            File dir = new File(this._properties.getOutputDir());
            isReady = dir.canWrite();
            if (!isReady) {
                JOptionPane.showMessageDialog(this._frame, "Cannot write to output directory");
            }
        } else {
            JOptionPane.showMessageDialog(this._frame, "You must select an output directory");
        }
        return isReady;
    }

    private boolean isTextReady(String text) {
        return text != null && text.length() > 0;
    }

    private void populateTextArea(File[] wavs) throws IOException, CDDBMismatchException, InterruptedException, ParseException {
        this._data.removeAll();
        int i = 0;
        while (i < wavs.length) {
            SongData row = new SongData();
            row.setFile(wavs[i].getName());
            this._data.setRow(row, i);
            ++i;
        }
        if (this._cddb.isInLocalDatabase()) {
            SongData[] rows = this._data.getAllRows();
            this._cddb.setInfo(rows);
            this._data.setAllRows(rows);
        }
    }

    private void selectDir(JTextField field, FileFilter filter) {
        JFileChooser chooser;
        if (field.getText() != null && field.getText().length() > 0) {
            chooser = new JFileChooser(field.getText());
        } else {
            chooser = new JFileChooser(".");
            field.setText(new File(".").getAbsolutePath());
        }
        chooser.setFileSelectionMode(1);
        chooser.setFileFilter(filter);
        int accepted = chooser.showDialog(this._frame, "Select");
        if (accepted == 0) {
            field.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void init() throws CDDBMismatchException, InterruptedException, IOException, ParseException {
        this._encode.addActionListener(this);
        this._encode.setMnemonic('E');
        this._propertyButton.addActionListener(this);
        this._propertyButton.setMnemonic('O');
        this._freeDB.addActionListener(this);
        this._freeDB.setMnemonic('C');
        this._menu.addActionListener(this);
        this._refresh.addActionListener(this);
        this._refresh.setMnemonic('R');
        this._properties = JOggProperties.getInstance();
        this._cddb = new JOggCDDB();
        if (this._properties.hasPropFile()) {
            this.populateTextArea(this.getWavFiles(this._properties.getWavDir()));
        }
        this.layout();
    }

    private File[] getWavFiles(String dir) {
        File f = new File(dir);
        return f.listFiles(new WavFilter());
    }

    private void layout() {
        this._frame.getRootPane().setJMenuBar(this._menu);
        GBLayout layout = new GBLayout(this._frame.getContentPane());
        layout.addComponent((Component)this._data, true);
        layout.addComponent((Component)this.getButtonPanel(), true);
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new BevelBorder(0));
        buttonPanel.add(this._encode);
        buttonPanel.add(this._propertyButton);
        buttonPanel.add(this._freeDB);
        buttonPanel.add(this._refresh);
        return buttonPanel;
    }

    private void saveProperties() {
        try {
            this._properties.save();
        }
        catch (IOException e) {
            this.showException(e);
        }
    }
}

